<?php
require_once 'config/db.php';

echo "=== DIAGNÓSTICO AVANZADO DE LOCKS ===\n\n";

try {
    $pdo = get_pdo();
    
    // 1. Verificar procesos activos ahora
    echo "1. PROCESOS MYSQL ACTIVOS:\n";
    $stmt = $pdo->query('SHOW PROCESSLIST');
    $processes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($processes as $process) {
        if ($process['Command'] !== 'Sleep') {
            echo "  ID: {$process['Id']} | User: {$process['User']} | DB: {$process['db']} | Command: {$process['Command']} | Time: {$process['Time']}s\n";
            echo "  State: {$process['State']}\n";
            echo "  Info: " . substr($process['Info'] ?? '', 0, 150) . "\n\n";
        }
    }
    
    // 2. Matar todos los procesos problemáticos activamente
    echo "2. LIMPIEZA AGRESIVA DE PROCESOS:\n";
    $killCount = 0;
    
    $stmt = $pdo->query('SHOW PROCESSLIST');
    $processes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $currentConnectionId = $pdo->query('SELECT CONNECTION_ID()')->fetchColumn();
    
    foreach ($processes as $process) {
        if ($process['Id'] != $currentConnectionId && 
            $process['Command'] !== 'Sleep' && 
            $process['Command'] !== 'Daemon' &&
            ($process['Time'] > 5 || strpos($process['Info'] ?? '', 'sp_so_preparar_auto') !== false)) {
            
            try {
                $pdo->exec("KILL {$process['Id']}");
                echo "  ✅ Proceso {$process['Id']} terminado\n";
                $killCount++;
            } catch (Exception $e) {
                echo "  ❌ No se pudo terminar proceso {$process['Id']}: {$e->getMessage()}\n";
            }
        }
    }
    
    echo "  Total procesos terminados: $killCount\n\n";
    
    // 3. Limpiar tablas temporales que puedan estar bloqueadas
    echo "3. LIMPIEZA DE TABLAS TEMPORALES:\n";
    try {
        $pdo->exec('DROP TEMPORARY TABLE IF EXISTS _plan');
        $pdo->exec('DROP TEMPORARY TABLE IF EXISTS _pend');
        $pdo->exec('DROP TEMPORARY TABLE IF EXISTS _cand_pick');
        $pdo->exec('DROP TEMPORARY TABLE IF EXISTS _cand_pick2');
        $pdo->exec('DROP TEMPORARY TABLE IF EXISTS _src_rows');
        echo "  ✅ Tablas temporales limpiadas\n";
    } catch (Exception $e) {
        echo "  ⚠️ Error limpiando temporales: {$e->getMessage()}\n";
    }
    
    // 4. Resetear todas las transacciones
    echo "\n4. RESET COMPLETO DE TRANSACCIONES:\n";
    try {
        $pdo->exec('ROLLBACK');
        $pdo->exec('SET TRANSACTION ISOLATION LEVEL READ COMMITTED');
        $pdo->exec('SET autocommit = 1');
        $pdo->exec('RESET QUERY CACHE');
        echo "  ✅ Transacciones reseteadas\n";
    } catch (Exception $e) {
        echo "  ⚠️ Error en reset: {$e->getMessage()}\n";
    }
    
    // 5. Verificar tabla de logs que puede estar causando el problema
    echo "\n5. VERIFICANDO TABLA DE LOGS:\n";
    try {
        $stmt = $pdo->query('SELECT COUNT(*) as count FROM so_preparar_auto_log WHERE pedido_codigo LIKE "SO-20251014%"');
        $logCount = $stmt->fetchColumn();
        echo "  Logs existentes para pedidos similares: $logCount\n";
        
        if ($logCount > 1000) {
            echo "  ⚠️ Muchos logs, limpiando...\n";
            $pdo->exec('DELETE FROM so_preparar_auto_log WHERE created_at < DATE_SUB(NOW(), INTERVAL 1 DAY)');
            echo "  ✅ Logs antiguos eliminados\n";
        }
    } catch (Exception $e) {
        echo "  ⚠️ Error verificando logs: {$e->getMessage()}\n";
    }
    
    // 6. Probar llamada directa con timeout más alto
    echo "\n6. CONFIGURACIÓN FINAL:\n";
    $pdo->exec('SET SESSION innodb_lock_wait_timeout = 300');
    $pdo->exec('SET SESSION lock_wait_timeout = 300');
    $pdo->exec('SET SESSION wait_timeout = 300');
    $pdo->exec('SET SESSION interactive_timeout = 300');
    echo "  ✅ Timeouts aumentados a 300 segundos\n";
    
    // 7. Verificar estado final
    echo "\n7. ESTADO FINAL:\n";
    $stmt = $pdo->query('SHOW PROCESSLIST');
    $finalProcesses = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $activeCount = 0;
    foreach ($finalProcesses as $process) {
        if ($process['Command'] !== 'Sleep' && $process['Command'] !== 'Daemon') {
            $activeCount++;
        }
    }
    
    echo "  Procesos activos restantes: $activeCount\n";
    echo "  ✅ Sistema listo para reintento\n\n";
    
    echo "🔧 RECOMENDACIÓN:\n";
    echo "1. Espera 30 segundos antes de reintentar\n";
    echo "2. Si persiste, reinicia Laragon completamente\n";
    echo "3. Verifica que no haya otro proceso usando la base de datos\n";
    
} catch (Throwable $e) {
    echo "Error en limpieza avanzada: " . $e->getMessage() . "\n";
}
?>