<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Aggressive cleanup for SO-20 ===\n";
    
    // Kill any transactions that might be blocking
    echo "Checking for blocking transactions...\n";
    try {
        $stmt = $pdo->query('SELECT trx_mysql_thread_id FROM INFORMATION_SCHEMA.INNODB_TRX WHERE trx_started < NOW() - INTERVAL 10 SECOND');
        $threads = $stmt->fetchAll(PDO::FETCH_COLUMN);
        foreach ($threads as $threadId) {
            echo "Killing long-running thread: $threadId\n";
            try {
                $pdo->exec("KILL $threadId");
            } catch (Throwable $e) {
                echo "  Could not kill thread $threadId: " . $e->getMessage() . "\n";
            }
        }
    } catch (Throwable $e) {
        echo "Could not check transactions: " . $e->getMessage() . "\n";
    }
    
    // Wait a moment for locks to clear
    sleep(1);
    
    // Check for SO-20 data
    echo "\nChecking SO-20 related data...\n";
    
    // 1. Find all preembarques for SO-20
    $stmt = $pdo->prepare('SELECT * FROM so_preembarque WHERE codigo LIKE ? OR pedido_id = 20');
    $stmt->execute(['%SO-20251014-155246%']);
    $preembarques = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($preembarques)) {
        echo "No preembarques found for SO-20\n";
    } else {
        foreach ($preembarques as $pre) {
            echo "Found preembarque: ID={$pre['id']}, codigo={$pre['codigo']}\n";
            
            // Delete related records with proper column names
            try {
                echo "  Deleting so_pre_pick records...\n";
                $stmt = $pdo->prepare('DELETE FROM so_pre_pick WHERE preembarque_id = ?');
                $stmt->execute([$pre['id']]);
                echo "    Deleted {$stmt->rowCount()} records\n";
            } catch (Throwable $e) {
                echo "    Error: " . $e->getMessage() . "\n";
            }
            
            try {
                echo "  Deleting so_pre_tarea records...\n";
                $stmt = $pdo->prepare('DELETE FROM so_pre_tarea WHERE preembarque_id = ?');
                $stmt->execute([$pre['id']]);
                echo "    Deleted {$stmt->rowCount()} records\n";
            } catch (Throwable $e) {
                echo "    Error: " . $e->getMessage() . "\n";
            }
            
            try {
                echo "  Deleting wh_move records...\n";
                $stmt = $pdo->prepare('DELETE FROM wh_move WHERE referencia LIKE ?');
                $stmt->execute(["%{$pre['codigo']}%"]);
                echo "    Deleted {$stmt->rowCount()} records\n";
            } catch (Throwable $e) {
                echo "    Error: " . $e->getMessage() . "\n";
            }
            
            try {
                echo "  Deleting preembarque...\n";
                $stmt = $pdo->prepare('DELETE FROM so_preembarque WHERE id = ?');
                $stmt->execute([$pre['id']]);
                echo "    Preembarque deleted\n";
            } catch (Throwable $e) {
                echo "    Error: " . $e->getMessage() . "\n";
            }
        }
    }
    
    // Reset pedido state
    echo "\nResetting SO-20 state...\n";
    try {
        $stmt = $pdo->prepare('UPDATE so_pedido SET estado_id = 2 WHERE id = 20');
        $stmt->execute();
        echo "SO-20 state reset to estado_id = 2\n";
    } catch (Throwable $e) {
        echo "Error resetting state: " . $e->getMessage() . "\n";
    }
    
    echo "\n=== Cleanup completed ===\n";
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>