<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    
    echo "=== ESTRUCTURA DE TABLAS PARA WORKFLOW COMPLETO ===\n\n";
    
    // 1. Tablas principales de pedidos
    echo "1. PEDIDOS Y DESTINOS:\n";
    $tables = ['so_pedido', 'so_pedido_dest', 'so_pedido_dest_item'];
    foreach ($tables as $table) {
        echo "\n$table:\n";
        try {
            $stmt = $pdo->query("DESCRIBE $table");
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "  {$row['Field']} ({$row['Type']}) {$row['Null']} {$row['Default']}\n";
            }
        } catch (Exception $e) {
            echo "  Error: " . $e->getMessage() . "\n";
        }
    }
    
    // 2. Productos y lotes
    echo "\n\n2. PRODUCTOS Y LOTES:\n";
    $tables = ['para_productos', 'wh_lote', 'wh_stock', 'wh_posicion'];
    foreach ($tables as $table) {
        echo "\n$table:\n";
        try {
            $stmt = $pdo->query("DESCRIBE $table");
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                echo "  {$row['Field']} ({$row['Type']}) {$row['Null']} {$row['Default']}\n";
            }
        } catch (Exception $e) {
            echo "  Error: " . $e->getMessage() . "\n";
        }
    }
    
    // 3. Estados
    echo "\n\n3. ESTADOS:\n";
    $stmt = $pdo->query('SELECT id, code, nombre FROM so_pedido_estado ORDER BY id');
    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "  {$row['id']}: {$row['code']} - {$row['nombre']}\n";
    }
    
    // 4. Verificar datos de ejemplo
    echo "\n\n4. DATOS DE EJEMPLO (SO-19):\n";
    $stmt = $pdo->query('
        SELECT p.id, p.codigo, p.estado_id, e.code as estado,
               COUNT(d.id) as destinos, 
               COUNT(i.id) as items
        FROM so_pedido p 
        LEFT JOIN so_pedido_estado e ON e.id = p.estado_id
        LEFT JOIN so_pedido_dest d ON d.pedido_id = p.id 
        LEFT JOIN so_pedido_dest_item i ON i.pedido_dest_id = d.id 
        WHERE p.id = 19
        GROUP BY p.id
    ');
    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($pedido) {
        print_r($pedido);
    }
    
    echo "\n\n5. ITEMS DE SO-19:\n";
    $stmt = $pdo->query('
        SELECT i.*, pr.denominacion, pr.sku 
        FROM so_pedido_dest_item i 
        JOIN so_pedido_dest d ON d.id = i.pedido_dest_id 
        LEFT JOIN para_productos pr ON pr.id = i.producto_id 
        WHERE d.pedido_id = 19 
        LIMIT 5
    ');
    while ($item = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "  SKU: {$item['sku']} | Producto: {$item['denominacion']} | Expected: UV={$item['expected_uv']}, UC={$item['expected_uc']} | Prepared: UV={$item['prepared_uv']}, UC={$item['prepared_uc']}\n";
    }
    
    echo "\n\n6. STOCK DISPONIBLE (muestra):\n";
    $stmt = $pdo->query('
        SELECT s.*, pr.denominacion, pr.sku, l.codigo as lote, pos.code as posicion
        FROM wh_stock s 
        LEFT JOIN para_productos pr ON pr.id = s.producto_id
        LEFT JOIN wh_lote l ON l.id = s.lote_id  
        LEFT JOIN wh_posicion pos ON pos.id = s.posicion_id
        WHERE s.qty_uv > 0 OR s.qty_uc > 0
        LIMIT 5
    ');
    while ($stock = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "  {$stock['sku']} en {$stock['posicion']} | Lote: {$stock['lote']} | Stock: UV={$stock['qty_uv']}, UC={$stock['qty_uc']}\n";
    }
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>