<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Active Transactions ===\n";
    $stmt = $pdo->query('SELECT * FROM INFORMATION_SCHEMA.INNODB_TRX');
    $trx = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (empty($trx)) {
        echo "No active transactions\n";
    } else {
        foreach ($trx as $row) {
            print_r($row);
        }
    }
    
    echo "\n=== Lock Waits ===\n";
    $stmt = $pdo->query('SELECT * FROM INFORMATION_SCHEMA.INNODB_LOCK_WAITS');
    $locks = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (empty($locks)) {
        echo "No lock waits\n";
    } else {
        foreach ($locks as $row) {
            print_r($row);
        }
    }
    
    echo "\n=== Process List (long running) ===\n";
    $stmt = $pdo->query('SHOW PROCESSLIST');
    $processes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($processes as $row) {
        if ($row['Time'] > 1 || $row['State'] !== '') {
            echo "ID: {$row['Id']}, User: {$row['User']}, Host: {$row['Host']}, DB: {$row['db']}, Command: {$row['Command']}, Time: {$row['Time']}, State: {$row['State']}, Info: {$row['Info']}\n";
        }
    }
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>