<?php
require __DIR__ . '/../config/db.php';

try {
  $pdo = get_pdo();
  
  echo "=== para_producto_pack ===\n";
  $st = $pdo->query('DESCRIBE para_producto_pack');
  while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
    echo $row['Field'] . " - " . $row['Type'] . "\n";
  }
  
  echo "\n=== para_producto_paletizado ===\n";
  $st = $pdo->query('DESCRIBE para_producto_paletizado');
  while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
    echo $row['Field'] . " - " . $row['Type'] . "\n";
  }
  
  echo "\n=== Ejemplo de JOIN ===\n";
  $st = $pdo->query("
    SELECT 
      p.id, p.sku, p.denominacion,
      pk.unidades_por_uv,
      pal.cajas_por_pallet
    FROM para_productos p
    LEFT JOIN para_producto_pack pk ON pk.producto_id = p.id
    LEFT JOIN para_producto_paletizado pal ON pal.producto_id = p.id
    LIMIT 3
  ");
  
  while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
    print_r($row);
  }
  
} catch (Exception $e) {
  echo "Error: " . $e->getMessage() . "\n";
}
