<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    
    echo "=== Available SO tables ===\n";
    $tables = $pdo->query("SHOW TABLES LIKE 'so_%'")->fetchAll(PDO::FETCH_COLUMN);
    foreach($tables as $table) {
        echo $table . "\n";
    }
    
    echo "\n=== Checking SO-20 data ===\n";
    $stmt = $pdo->prepare('SELECT id, codigo, estado_id FROM so_pedido WHERE id = 20');
    $stmt->execute();
    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);
    print_r($pedido);

    echo "\n=== Checking if there is already a preembarque ===\n";
    $stmt = $pdo->prepare('SELECT * FROM so_preembarque WHERE codigo = ?');
    $stmt->execute(['PRE-SO-20251014-155246']);
    $pre = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($pre) {
        echo "Preembarque already exists:\n";
        print_r($pre);
    } else {
        echo "No preembarque found\n";
    }
    
    echo "\n=== Try a different pedido (19) ===\n";
    $stmt = $pdo->prepare('SELECT id, codigo, estado_id FROM so_pedido WHERE id = 19');
    $stmt->execute();
    $pedido19 = $stmt->fetch(PDO::FETCH_ASSOC);
    print_r($pedido19);
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>