<?php
require __DIR__ . '/../config/db.php';
$pdo = getPDO();

echo "so_embarque columns:\n";
$result = $pdo->query('DESCRIBE so_embarque');
while ($row = $result->fetch()) {
    echo "  - {$row['Field']} ({$row['Type']})\n";
}

echo "\nAll tables with 'embarque' in name:\n";
$result = $pdo->query("SHOW TABLES");
while ($row = $result->fetch(PDO::FETCH_NUM)) {
    if (strpos($row[0], 'embarque') !== false) {
        echo "  - {$row[0]}\n";
    }
}

echo "\nAll tables with 'preembarque' or 'pre' in name:\n";
$result = $pdo->query("SHOW TABLES");
while ($row = $result->fetch(PDO::FETCH_NUM)) {
    if (strpos($row[0], 'preembarque') !== false || strpos($row[0], 'pre') !== false) {
        echo "  - {$row[0]}\n";
    }
}

echo "\nChecking if so_preembarque exists:\n";
try {
    $result = $pdo->query('DESCRIBE so_preembarque');
    echo "so_preembarque columns:\n";
    while ($row = $result->fetch()) {
        echo "  - {$row['Field']} ({$row['Type']})\n";
    }
} catch (Exception $e) {
    echo "  - so_preembarque does not exist\n";
}