<?php
require_once __DIR__ . '/../config/db.php';

$pdo = get_pdo();

// Verificar si existe wh_move
$check = $pdo->query("SHOW TABLES LIKE 'wh_move'")->fetch();
if (!$check) {
    die("Tabla wh_move NO existe\n");
}

echo "=== Tabla wh_move existe ===\n\n";

// Contar registros tipo IN
$count = $pdo->query("SELECT COUNT(*) FROM wh_move WHERE tipo='IN'")->fetchColumn();
echo "Total movimientos tipo='IN': $count\n\n";

// Mostrar algunos registros
echo "=== Primeros 3 movimientos IN ===\n";
$st = $pdo->query("SELECT * FROM wh_move WHERE tipo='IN' LIMIT 3");
$rows = $st->fetchAll(PDO::FETCH_ASSOC);
print_r($rows);

// Verificar estructura de columnas
echo "\n=== Columnas de wh_move ===\n";
$cols = $pdo->query("DESCRIBE wh_move")->fetchAll(PDO::FETCH_ASSOC);
foreach ($cols as $col) {
    echo $col['Field'] . " (" . $col['Type'] . ")\n";
}
