<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    
    echo "=== Estados disponibles en so_pedido_estado ===\n";
    $stmt = $pdo->query('SELECT id, code, nombre FROM so_pedido_estado ORDER BY id');
    while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "{$row['id']}: {$row['code']} - {$row['nombre']}\n";
    }
    
    echo "\n=== Estado actual de SO-19 ===\n";
    $stmt = $pdo->query('SELECT p.id, p.codigo, p.estado_id, e.code, e.nombre FROM so_pedido p JOIN so_pedido_estado e ON e.id = p.estado_id WHERE p.id = 19');
    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($pedido) {
        echo "SO-19: {$pedido['codigo']} → Estado {$pedido['estado_id']}: {$pedido['code']} ({$pedido['nombre']})\n";
    }
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>