<?php
require_once 'config/db.php';

echo "=== LIMPIEZA DE LOCKS Y TRANSACCIONES ===\n\n";

try {
    $pdo = get_pdo();
    
    // 1. Identificar y matar procesos problemáticos
    echo "1. IDENTIFICANDO PROCESOS PROBLEMÁTICOS:\n";
    $stmt = $pdo->query('SHOW PROCESSLIST');
    $processes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $problematicProcesses = [];
    foreach ($processes as $process) {
        // Buscar procesos que llevan mucho tiempo o están bloqueados
        if ($process['Command'] === 'Execute' && $process['Time'] > 10) {
            $problematicProcesses[] = $process;
            echo "  🔴 Proceso problemático ID: {$process['Id']} | Time: {$process['Time']}s\n";
            echo "      Info: " . substr($process['Info'] ?? '', 0, 100) . "\n";
        }
    }
    
    // 2. Matar procesos problemáticos (excepto el nuestro)
    if (!empty($problematicProcesses)) {
        echo "\n2. MATANDO PROCESOS PROBLEMÁTICOS:\n";
        foreach ($problematicProcesses as $process) {
            if ($process['Id'] != $pdo->query('SELECT CONNECTION_ID()')->fetchColumn()) {
                try {
                    $pdo->exec("KILL {$process['Id']}");
                    echo "  ✅ Proceso {$process['Id']} terminado\n";
                } catch (Exception $e) {
                    echo "  ❌ No se pudo matar proceso {$process['Id']}: {$e->getMessage()}\n";
                }
            }
        }
    } else {
        echo "\n2. ✅ No hay procesos problemáticos que matar\n";
    }
    
    // 3. Rollback de transacciones pendientes
    echo "\n3. LIMPIANDO TRANSACCIONES:\n";
    try {
        $pdo->exec('ROLLBACK');
        echo "  ✅ Rollback ejecutado\n";
    } catch (Exception $e) {
        echo "  ⚠️ Rollback: {$e->getMessage()}\n";
    }
    
    // 4. Verificar estado final
    echo "\n4. VERIFICACIÓN FINAL:\n";
    $stmt = $pdo->query('SHOW PROCESSLIST');
    $processesAfter = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $activeCount = 0;
    foreach ($processesAfter as $process) {
        if ($process['Command'] !== 'Sleep' && $process['Command'] !== 'Daemon') {
            $activeCount++;
        }
    }
    
    echo "  Procesos activos restantes: $activeCount\n";
    
    // 5. Verificar transacciones
    try {
        $stmt = $pdo->query('SELECT COUNT(*) as count FROM INFORMATION_SCHEMA.INNODB_TRX');
        $trxCount = $stmt->fetchColumn();
        echo "  Transacciones pendientes: $trxCount\n";
    } catch (Exception $e) {
        echo "  ⚠️ No se pudo verificar transacciones\n";
    }
    
    echo "\n✅ LIMPIEZA COMPLETADA - Listo para reintentar Plan FEFO\n";
    
} catch (Throwable $e) {
    echo "Error en limpieza: " . $e->getMessage() . "\n";
}
?>