<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Cleaning up SO-20 preembarque data ===\n";
    
    // First, let's check the table structures
    echo "Checking table structures...\n";
    
    $tables = ['so_pre_pick', 'so_pre_tarea', 'wh_move'];
    foreach ($tables as $table) {
        echo "\n$table columns:\n";
        try {
            $columns = $pdo->query("DESCRIBE $table")->fetchAll(PDO::FETCH_ASSOC);
            foreach ($columns as $col) {
                echo "  {$col['Field']} ({$col['Type']})\n";
            }
        } catch (Throwable $e) {
            echo "  Error: " . $e->getMessage() . "\n";
        }
    }
    
    // Check what data exists
    $stmt = $pdo->prepare('SELECT * FROM so_preembarque WHERE codigo = ?');
    $stmt->execute(['PRE-SO-20251014-155246']);
    $pre = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($pre) {
        echo "\nFound preembarque ID: {$pre['id']}\n";
        echo "For now, just deleting the preembarque itself...\n";
        
        // Just delete the preembarque - let MySQL handle cascading
        $stmt = $pdo->prepare('DELETE FROM so_preembarque WHERE id = ?');
        $stmt->execute([$pre['id']]);
        echo "Preembarque deleted\n";
        
        // Reset pedido state
        echo "Resetting pedido state...\n";
        $stmt = $pdo->prepare('UPDATE so_pedido SET estado_id = 2 WHERE id = 20');
        $stmt->execute();
        echo "Pedido state reset\n";
        
        echo "\n=== Cleanup completed successfully ===\n";
        
    } else {
        echo "No preembarque found for SO-20\n";
    }
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>