<?php
declare(strict_types=1);

/**
 * Ejecuta la API so_confirm_commit.php desde CLI para un batch ya cargado en staging.
 *
 * Uso:
 *   php scripts/confirm_salidas_batch.php --batch-id=123 --cliente-id=1
 */

$options = getopt('', [
    'batch-id:',
    'cliente-id:',
]);

if (empty($options['batch-id']) || empty($options['cliente-id'])) {
    fwrite(STDERR, "Uso: php scripts/confirm_salidas_batch.php --batch-id=ID --cliente-id=ID\n");
    exit(1);
}

$batchId = (int)$options['batch-id'];
$clienteId = (int)$options['cliente-id'];
if ($batchId <= 0 || $clienteId <= 0) {
    fwrite(STDERR, "batch-id y cliente-id deben ser mayores a cero.\n");
    exit(1);
}

$_SERVER['REQUEST_METHOD'] = 'POST';
$_POST['batch_id'] = (string)$batchId;
$_POST['cliente_id'] = (string)$clienteId;

$ROOT = dirname(__DIR__);
require $ROOT . '/api/operaciones/so_confirm_commit.php';
