<?php
// scripts/create_pl_ingreso_for_pl.php
declare(strict_types=1);
if ($argc < 2) { echo "Usage: php scripts/create_pl_ingreso_for_pl.php PL_ID\n"; exit(1); }
// Usage: php create_pl_ingreso_for_pl.php PL_ID [movil_id] [chofer_id]
$pl = (int)$argv[1];
$movilId = isset($argv[2]) ? (int)$argv[2] : null;
$choferId = isset($argv[3]) ? (int)$argv[3] : null;
require_once __DIR__ . '/../config/db.php';
$pdo = getPDO();

// Check exists
$st = $pdo->prepare('SELECT id FROM pl_ingreso WHERE packinglist_id = ? LIMIT 1');
$st->execute([$pl]);
if ($st->fetchColumn()) { echo "pl_ingreso already exists for PL $pl\n"; exit(0); }

// Resolve deposito
$depositoId = null;
try {
  $q = $pdo->query("SELECT id FROM wh_deposito ORDER BY id LIMIT 1");
  $depositoId = (int)$q->fetchColumn();
} catch (Throwable $e) { $depositoId = null; }

// Minimal insert
// fecha_ingreso is NOT NULL in schema; default to today
$today = date('Y-m-d');
$cols = ['packinglist_id', 'fecha_ingreso']; $vals = ['?', '?']; $params = [$pl, $today];
if ($depositoId) { $cols[] = 'deposito_id'; $vals[]='?'; $params[] = $depositoId; }
if ($movilId) { $cols[] = 'movil_id'; $vals[]='?'; $params[] = $movilId; }
if ($choferId) { $cols[] = 'chofer_id'; $vals[]='?'; $params[] = $choferId; }
$sql = "INSERT INTO pl_ingreso (".implode(',', $cols).") VALUES (".implode(',', $vals).")";
$pdo->prepare($sql)->execute($params);
echo "Inserted pl_ingreso id " . $pdo->lastInsertId() . " for PL $pl\n";
