<?php
require_once 'config/db.php';

echo "=== DIAGNÓSTICO DE LOCK TIMEOUT PARA SO-28 ===\n\n";

try {
    $pdo = get_pdo();
    
    // 1. Verificar procesos activos
    echo "1. PROCESOS ACTIVOS EN MYSQL:\n";
    $stmt = $pdo->query('SHOW PROCESSLIST');
    $processes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($processes as $process) {
        if ($process['Command'] !== 'Sleep') {
            echo "  ID: {$process['Id']} | User: {$process['User']} | Command: {$process['Command']} | Time: {$process['Time']}s\n";
            echo "  Info: " . substr($process['Info'] ?? '', 0, 100) . "\n";
        }
    }
    
    // 2. Verificar locks activos (MySQL 8 usa performance_schema)
    echo "\n2. LOCKS ACTIVOS:\n";
    try {
        $stmt = $pdo->query("SELECT * FROM performance_schema.data_locks");
        $locks = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($locks)) {
            echo "  ✅ No hay locks activos\n";
        } else {
            foreach ($locks as $lock) {
                $obj = $lock['OBJECT_SCHEMA'] . '.' . $lock['OBJECT_NAME'];
                echo "  Lock: {$obj} | Mode: {$lock['LOCK_MODE']} | Type: {$lock['LOCK_TYPE']} | Trx: {$lock['ENGINE_TRANSACTION_ID']}\n";
            }
        }
    } catch (Exception $e) {
        echo "  ⚠️ No se pudo consultar locks: " . $e->getMessage() . "\n";
    }
    
    // 3. Verificar transacciones pendientes
    echo "\n3. TRANSACCIONES PENDIENTES:\n";
    try {
        $stmt = $pdo->query('SELECT * FROM INFORMATION_SCHEMA.INNODB_TRX');
        $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($transactions)) {
            echo "  ✅ No hay transacciones pendientes\n";
        } else {
            foreach ($transactions as $trx) {
                echo "  TRX ID: {$trx['trx_id']} | State: {$trx['trx_state']} | Started: {$trx['trx_started']}\n";
            }
        }
    } catch (Exception $e) {
        echo "  ⚠️ No se pudo consultar transacciones: " . $e->getMessage() . "\n";
    }
    
    // 4. Verificar si hay preembarques existentes que puedan causar conflicto
    echo "\n4. PREEMBARQUES EXISTENTES:\n";
    $stmt = $pdo->query('SELECT id, codigo, pedido_id, created_at FROM so_preembarque ORDER BY id DESC LIMIT 5');
    $preembarques = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($preembarques as $pre) {
    echo "  ID: {$pre['id']} | Código: {$pre['codigo']} | Pedido: {$pre['pedido_id']} | Creado: {$pre['created_at']}\n";
    }
    
    // 5. Verificar configuración de timeout
    echo "\n5. CONFIGURACIÓN DE TIMEOUTS:\n";
    $configs = [
        'innodb_lock_wait_timeout',
        'lock_wait_timeout', 
        'wait_timeout',
        'interactive_timeout'
    ];
    
    foreach ($configs as $config) {
        try {
            $stmt = $pdo->query("SHOW VARIABLES LIKE '$config'");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($result) {
                echo "  {$result['Variable_name']}: {$result['Value']}s\n";
            }
        } catch (Exception $e) {
            echo "  ⚠️ No se pudo consultar $config\n";
        }
    }
    
    // 6. Sugerir soluciones
    echo "\n6. POSIBLES SOLUCIONES:\n";
    echo "  a) Reiniciar conexiones MySQL: KILL procesos largos\n";
    echo "  b) Verificar stored procedure sp_so_preparar_auto\n";
    echo "  c) Ejecutar con parámetro simulate=1 primero\n";
    echo "  d) Limpiar preembarques huérfanos\n";
    echo "  e) Aumentar innodb_lock_wait_timeout\n";
    
} catch (Throwable $e) {
    echo "Error en diagnóstico: " . $e->getMessage() . "\n";
}
?>