<?php
/**
 * Diagnóstico completo de UV→UC sin base de datos
 * Simula el flujo completo para identificar problemas
 */
declare(strict_types=1);

echo "=== Diagnóstico UV→UC (Abrir cajas para sacar unidades) ===\n\n";

// 1. Verificar que el parámetro llega al endpoint
echo "🔍 1. VERIFICACIÓN DE ENDPOINTS\n";
echo str_repeat("-", 50) . "\n";

echo "✅ Checklist de archivos modificados:\n";

// Verificar so_preparar_auto.php
$auto_content = file_get_contents(__DIR__ . '/../api/operaciones/so_preparar_auto.php');
if (strpos($auto_content, '$uvToUc') !== false) {
    echo "✅ so_preparar_auto.php - Variable \$uvToUc definida\n";
} else {
    echo "❌ so_preparar_auto.php - Variable \$uvToUc NO encontrada\n";
}

if (strpos($auto_content, '@so_pre_uv_to_uc') !== false) {
    echo "✅ so_preparar_auto.php - Variable de sesión @so_pre_uv_to_uc configurada\n";
} else {
    echo "❌ so_preparar_auto.php - Variable de sesión @so_pre_uv_to_uc NO configurada\n";
}

// Verificar so_preparar_simple.php
$simple_content = file_get_contents(__DIR__ . '/../api/operaciones/so_preparar_simple.php');
if (strpos($simple_content, '$uvToUc') !== false) {
    echo "✅ so_preparar_simple.php - Variable \$uvToUc definida\n";
} else {
    echo "❌ so_preparar_simple.php - Variable \$uvToUc NO encontrada\n";
}

if (strpos($simple_content, '@so_pre_uv_to_uc') !== false) {
    echo "✅ so_preparar_simple.php - Variable de sesión @so_pre_uv_to_uc configurada\n";
} else {
    echo "❌ so_preparar_simple.php - Variable de sesión @so_pre_uv_to_uc NO configurada\n";
}

echo "\n🔍 2. VERIFICACIÓN DE FRONTEND\n";
echo str_repeat("-", 50) . "\n";

// Verificar JavaScript
$js_content = file_get_contents(__DIR__ . '/../public/page-scripts/pages/salidas/preparacion_scripts.js');
if (strpos($js_content, '$chkUvToUc') !== false) {
    echo "✅ JavaScript - Variable \$chkUvToUc definida\n";
} else {
    echo "❌ JavaScript - Variable \$chkUvToUc NO encontrada\n";
}

if (strpos($js_content, 'so_prep_uv_to_uc_v1') !== false) {
    echo "✅ JavaScript - localStorage key para UV→UC definida\n";
} else {
    echo "❌ JavaScript - localStorage key para UV→UC NO encontrada\n";
}

$uv_to_uc_count = substr_count($js_content, 'uv_to_uc:');
echo "✅ JavaScript - Parámetro uv_to_uc enviado en $uv_to_uc_count peticiones AJAX\n";

// Verificar HTML
$html_content = file_get_contents(__DIR__ . '/../views/salidas/preparacion/index.php');
if (strpos($html_content, 'chkUvToUc') !== false) {
    echo "✅ HTML - Checkbox chkUvToUc presente\n";
} else {
    echo "❌ HTML - Checkbox chkUvToUc NO encontrado\n";
}

echo "\n🔍 3. VERIFICACIÓN DE STORED PROCEDURE\n";
echo str_repeat("-", 50) . "\n";

// Verificar SP
$sp_content = file_get_contents(__DIR__ . '/apply_sp_preparar_auto.php');
if (strpos($sp_content, 'v_uv_to_uc') !== false) {
    echo "✅ SP - Variable v_uv_to_uc declarada\n";
} else {
    echo "❌ SP - Variable v_uv_to_uc NO encontrada\n";
}

if (strpos($sp_content, '@so_pre_uv_to_uc') !== false) {
    echo "✅ SP - Inicialización desde @so_pre_uv_to_uc\n";
} else {
    echo "❌ SP - Inicialización desde @so_pre_uv_to_uc NO encontrada\n";
}

$uv_to_uc_checks = substr_count($sp_content, 'v_uv_to_uc = 1');
echo "✅ SP - Lógica UV→UC presente en $uv_to_uc_checks fases\n";

if (strpos($sp_content, 'UV→UC: Breaking') !== false) {
    echo "✅ SP - Logs de debug UV→UC presentes\n";
} else {
    echo "❌ SP - Logs de debug UV→UC NO encontrados\n";
}

echo "\n🔍 4. ANÁLISIS DE LÓGICA UV→UC\n";
echo str_repeat("-", 50) . "\n";

// Buscar condiciones UV→UC
preg_match_all('/IF v_uv_to_uc = 1[^;]+THEN/', $sp_content, $conditions);
echo "Condiciones UV→UC encontradas: " . count($conditions[0]) . "\n";

foreach ($conditions[0] as $i => $condition) {
    echo "\n📋 Condición " . ($i + 1) . ":\n";
    $clean_condition = preg_replace('/\s+/', ' ', $condition);
    echo "   " . $clean_condition . "\n";
    
    // Analizar qué requiere cada condición
    if (strpos($condition, 'v_uc_per_uv > 0') !== false) {
        echo "   ✅ Requiere factor de conversión v_uc_per_uv > 0\n";
    }
    
    if (strpos($condition, 'v_need_uc - v_take_uc') !== false) {
        echo "   ✅ Requiere déficit de UC (need > take)\n";
    }
    
    if (strpos($condition, 'cur_uv,0) > 0') !== false) {
        echo "   ✅ Requiere disponibilidad de UV\n";
    }
    
    if (strpos($condition, 'cur_uc,0) - v_take_uc_base) = 0') !== false) {
        echo "   ⚠️  Requiere que NO haya UC disponibles (condición restrictiva)\n";
    } else {
        echo "   ✅ Condición menos restrictiva (permite UV→UC con UC parciales)\n";
    }
}

echo "\n🔍 5. SIMULACIÓN DE CASOS DE USO\n";
echo str_repeat("-", 50) . "\n";

echo "📊 Caso típico de UV→UC:\n";
echo "   Pedido necesita: 150 UC\n";
echo "   Stock disponible: 0 UC, 2 UV (cajas de 100 UC c/u)\n";
echo "   Conversión esperada: Abrir 2 UV → 200 UC disponibles\n";
echo "   Resultado: Tomar 150 UC, sobran 50 UC\n\n";

echo "📊 Caso con stock mixto:\n";
echo "   Pedido necesita: 150 UC\n";
echo "   Stock disponible: 50 UC, 1 UV (caja de 100 UC)\n";
echo "   Conversión esperada: Tomar 50 UC + abrir 1 UV → 150 UC total\n";
echo "   Resultado: Pedido satisfecho completamente\n\n";

echo "🔍 6. PASOS PARA DEBUGGING\n";
echo str_repeat("-", 50) . "\n";

echo "Para debuggear en entorno con BD:\n\n";

echo "1️⃣ Activar logging:\n";
echo "   - Marcar checkbox 'UV→UC (abrir cajas)' en interfaz\n";
echo "   - Usar debug=1 en peticiones\n";
echo "   - Verificar que @so_pre_uv_to_uc = 1\n\n";

echo "2️⃣ Verificar condiciones:\n";
echo "   - Producto debe tener para_producto_pack.unidades_por_uv > 0\n";
echo "   - Debe haber stock UV (cajas) disponible\n";
echo "   - Debe haber déficit de UC en pedido\n\n";

echo "3️⃣ Revisar logs:\n";
echo "   - SELECT * FROM so_preparar_auto_log WHERE msg LIKE '%UV→UC%'\n";
echo "   - Buscar mensajes 'UV→UC Check:' y 'UV→UC: Breaking'\n";
echo "   - Verificar parámetros en logs de INIT\n\n";

echo "4️⃣ Verificar movimientos:\n";
echo "   - SELECT * FROM wh_move WHERE pre_id IN (SELECT id FROM so_preembarque WHERE codigo LIKE 'PRE-%')\n";
echo "   - Buscar movimientos con cantidad_uv > 0 (apertura de cajas)\n\n";

echo "💡 TIPS:\n";
echo "   - Si no hay logs 'UV→UC Check:', el parámetro no llega al SP\n";
echo "   - Si hay checks pero no conversiones, revisar las condiciones\n";
echo "   - Si hay conversiones pero no movimientos, revisar la lógica de inserción\n\n";

echo "✅ Diagnóstico completado. ¡Implementación UV→UC lista para testing!\n";