<?php
require_once 'config/db.php';
$pdo = get_pdo();

echo "Buscando tablas relacionadas con preparación:\n\n";

$result = $pdo->query("SHOW TABLES");
$tables = [];
while($row = $result->fetch()) {
    $table = array_values($row)[0];
    if (strpos($table, 'pre') !== false || strpos($table, 'preparacion') !== false) {
        $tables[] = $table;
    }
}

foreach($tables as $table) {
    echo "Tabla: $table\n";
    try {
        $result = $pdo->query("DESCRIBE $table");
        while($row = $result->fetch()) {
            echo "  - " . $row['Field'] . ' (' . $row['Type'] . ")\n";
        }
        echo "\n";
    } catch (Exception $e) {
        echo "  Error: " . $e->getMessage() . "\n\n";
    }
}
?>