<?php
require __DIR__ . '/../config/db.php';

try {
  $pdo = get_pdo();
  
  // Buscar columnas con 'unidades_por_caja' en todas las tablas
  $sql = "SELECT TABLE_NAME, COLUMN_NAME 
          FROM INFORMATION_SCHEMA.COLUMNS 
          WHERE TABLE_SCHEMA = DATABASE() 
          AND (COLUMN_NAME LIKE '%unidades%' OR COLUMN_NAME LIKE '%cajas%')
          ORDER BY TABLE_NAME, COLUMN_NAME";
  
  $st = $pdo->query($sql);
  
  echo "Columnas con unidades/cajas:\n";
  echo str_repeat('-', 80) . "\n";
  
  while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
    echo $row['TABLE_NAME'] . " -> " . $row['COLUMN_NAME'] . "\n";
  }
  
} catch (Exception $e) {
  echo "Error: " . $e->getMessage() . "\n";
}
