<?php
require_once 'config/db.php';

echo "=== SOLUCIÓN DEFINITIVA DE LOCKS ===\n\n";

try {
    $pdo = get_pdo();
    
    // 1. Aumentar timeout temporalmente
    echo "1. CONFIGURANDO TIMEOUTS:\n";
    $pdo->exec('SET SESSION innodb_lock_wait_timeout = 120');
    $pdo->exec('SET SESSION lock_wait_timeout = 120');
    echo "  ✅ Timeouts aumentados a 120 segundos\n";
    
    // 2. Forzar rollback y commit de cualquier transacción pendiente
    echo "\n2. LIMPIEZA FORZADA:\n";
    try {
        $pdo->exec('ROLLBACK');
        $pdo->exec('START TRANSACTION');
        $pdo->exec('COMMIT');
        echo "  ✅ Transacciones limpiadas\n";
    } catch (Exception $e) {
        echo "  ⚠️ Limpieza: {$e->getMessage()}\n";
    }
    
    // 3. Verificar si el stored procedure existe
    echo "\n3. VERIFICANDO STORED PROCEDURE:\n";
    $stmt = $pdo->query("SHOW PROCEDURE STATUS WHERE Name = 'sp_so_preparar_auto'");
    $proc = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($proc) {
        echo "  ✅ sp_so_preparar_auto existe\n";
        echo "  Creado: {$proc['Created']}\n";
        echo "  Modificado: {$proc['Modified']}\n";
    } else {
        echo "  ❌ sp_so_preparar_auto NO existe\n";
    }
    
    // 4. Intentar una operación simple para probar locks
    echo "\n4. PRUEBA DE LOCKS:\n";
    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM so_pedido WHERE id = ?');
        $stmt->execute([28]);
        $count = $stmt->fetchColumn();
        $pdo->commit();
        echo "  ✅ Consulta simple exitosa (pedido SO-28 existe: $count)\n";
    } catch (Exception $e) {
        $pdo->rollback();
        echo "  ❌ Error en consulta simple: {$e->getMessage()}\n";
    }
    
    // 5. Probar llamada directa al stored procedure con parámetros mínimos
    echo "\n5. PRUEBA DIRECTA DEL STORED PROCEDURE:\n";
    try {
        $stmt = $pdo->prepare('CALL sp_so_preparar_auto(?, ?, ?, ?, ?)');
        $stmt->execute([28, 'DEP1', 3, 1, 1]); // so_id, deposito, prep_pos, debug, simulate
        
        $results = [];
        do {
            $rowset = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if ($rowset) {
                $results[] = $rowset;
            }
        } while ($stmt->nextRowset());
        
        echo "  ✅ Stored procedure ejecutado\n";
        echo "  Resultados obtenidos: " . count($results) . " sets\n";
        
    } catch (Exception $e) {
        echo "  ❌ Error en stored procedure: {$e->getMessage()}\n";
        echo "  Código: {$e->getCode()}\n";
        
        // Si hay lock timeout, intentar alternativa
        if (strpos($e->getMessage(), '1205') !== false) {
            echo "\n  🔧 ALTERNATIVA - Reiniciar servidor MySQL:\n";
            echo "    1. Parar Laragon\n";
            echo "    2. Reiniciar Laragon\n";
            echo "    3. Verificar que no haya procesos MySQL colgados\n";
        }
    }
    
} catch (Throwable $e) {
    echo "Error general: " . $e->getMessage() . "\n";
}
?>