<?php
require __DIR__ . '/../vendor/autoload.php';

$spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$headers = [
    'sku',
    'denominacion',
    'lote',
    'fecha_produccion',
    'fecha_vencimiento',
    'uv_cajas',
    'uc_por_caja',
    'uc_sueltas',
    'pallet_hint',
    'position_hint',
];
$data = [
    '4409',
    'MARGARINA OK 10 KG',
    '90-8900',
    '2025-01-01',
    '2026-01-01',
    160,
    60,
    30,
    null,
    null,
];
$sheet->fromArray([$headers, $data], null, 'A1');

$path = realpath(__DIR__ . '/../tmp');
if ($path === false) {
    $path = __DIR__ . '/../tmp';
}
if (!is_dir($path)) {
    mkdir($path, 0775, true);
}
$filePath = $path . '/pl_test_upload.xlsx';
$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
$writer->save($filePath);

echo "Generated test PL at: {$filePath}\n";
