<?php
// scripts/inspect_ingreso.php
declare(strict_types=1);
if ($argc < 2) { echo "Usage: php scripts/inspect_ingreso.php PL_ID\n"; exit(1); }
$id = (int)$argv[1];
require_once __DIR__ . '/../config/db.php';
$pdo = getPDO();
try {
    $st = $pdo->prepare('SELECT * FROM pl_ingreso WHERE packinglist_id = ? ORDER BY created_at DESC LIMIT 1');
} catch (Throwable $e) {
    echo "pl_ingreso table not present or query failed: " . $e->getMessage() . "\n";
    exit(2);
}
$st->execute([$id]);
$row = $st->fetch(PDO::FETCH_ASSOC);
if (!$row) { echo "No pl_ingreso row for PL $id\n"; exit(2); }
foreach ($row as $k => $v) echo "$k: " . (is_null($v)?'<null>':$v) . "\n";
