<?php
// scripts/inspect_pl.php
declare(strict_types=1);
if ($argc < 2) { echo "Usage: php scripts/inspect_pl.php PL_ID\n"; exit(1); }
$id = (int)$argv[1];
require_once __DIR__ . '/../config/db.php';
$pdo = getPDO();
$st = $pdo->prepare('SELECT * FROM pl_packinglist WHERE id = ? LIMIT 1');
$st->execute([$id]);
$row = $st->fetch(PDO::FETCH_ASSOC);
if (!$row) { echo "PL not found: $id\n"; exit(2); }
foreach ($row as $k => $v) echo "$k: " . (is_null($v)?'<null>':$v) . "\n";
