<?php
require_once 'config/db.php';
$pdo = get_pdo();
try {
    $pdo->exec('KILL 13');
    echo "Proceso 13 terminado\n";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

// Ahora probemos nuevamente con una llamada real al endpoint
echo "\nProbando llamada real al endpoint...\n";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://sol.test/api/operaciones/so_preparar_auto.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
    'so_id' => 28,
    'deposito_code' => 'DEP1',
    'prep_posicion_id' => 3,
    'debug' => 1,
    'simulate' => 0  // REAL, no simulación
]));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 120);

$start = microtime(true);
$response = curl_exec($ch);
$duration = microtime(true) - $start;
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "Tiempo: " . round($duration, 2) . "s\n";
echo "HTTP Code: $httpCode\n";
if ($error) echo "cURL Error: $error\n";
echo "Response:\n$response\n";
?>