<?php
$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    
    echo "=== Killing the blocking transaction (ID 49) ===\n";
    
    // First check if it still exists
    $stmt = $pdo->query('SHOW PROCESSLIST');
    $found = false;
    while($row = $stmt->fetch()) {
        if($row['Id'] == 49) {
            echo "Found blocking process: ID={$row['Id']}, User={$row['User']}, Time={$row['Time']}s, State={$row['State']}\n";
            $found = true;
            break;
        }
    }
    
    if ($found) {
        $pdo->exec('KILL 49');
        echo "Transaction 49 killed successfully\n";
    } else {
        echo "Transaction 49 no longer exists\n";
    }
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>