<?php
// scripts/list_productos.php
// List a few products for testing

declare(strict_types=1);
require_once __DIR__ . '/../config/db.php';

try {
  $pdo = getPDO();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');
  $st = $pdo->query("SELECT id, sku, denominacion FROM para_productos ORDER BY id ASC LIMIT 10");
  $rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
  foreach ($rows as $r) {
    echo $r['id'] . "\t" . $r['sku'] . "\t" . $r['denominacion'] . "\n";
  }
} catch (Throwable $e) {
  fwrite(STDERR, 'Error: ' . $e->getMessage() . "\n");
  exit(1);
}
