<?php
require_once __DIR__ . '/../config/db.php';

$pdo = get_pdo();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$sql = file_get_contents(__DIR__ . '/../database/migrations/2025_11_04_crear_tablas_inventario_conteo.sql');

// Eliminar comentarios y separar por punto y coma
$statements = array_filter(
    array_map('trim', explode(';', $sql)),
    function($stmt) {
        return !empty($stmt) && !str_starts_with($stmt, '--');
    }
);

echo "Ejecutando migración de inventario/conteo...\n\n";

foreach ($statements as $i => $statement) {
    if (empty($statement)) continue;
    
    try {
        $pdo->exec($statement);
        echo "✓ Statement " . ($i + 1) . " ejecutado correctamente\n";
    } catch (PDOException $e) {
        echo "✗ Error en statement " . ($i + 1) . ": " . $e->getMessage() . "\n";
        if (str_contains($e->getMessage(), 'already exists')) {
            echo "  (Tabla ya existe, continuando...)\n";
        } else {
            throw $e;
        }
    }
}

echo "\n✅ Migración completada!\n";

// Verificar tablas creadas
echo "\n=== Tablas creadas ===\n";
$tables = $pdo->query("SHOW TABLES LIKE 'inv_%'")->fetchAll(PDO::FETCH_COLUMN);
foreach ($tables as $table) {
    $count = $pdo->query("SELECT COUNT(*) FROM $table")->fetchColumn();
    echo "- $table (registros: $count)\n";
}
