<?php
// scripts/print_so_code.php
// Imprime códigos de so_pedido y permite resolver un id puntual.
// Uso:
//   php scripts/print_so_code.php             # lista últimos 10
//   php scripts/print_so_code.php --id=3      # imprime solo el código de id=3

declare(strict_types=1);
require_once __DIR__ . '/../config/db.php';

$options = getopt('', ['id::']);
$id = isset($options['id']) ? (int)$options['id'] : null;

$pdo = getPDO();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->exec("SET NAMES utf8mb4");

if ($id) {
    $st = $pdo->prepare('SELECT codigo FROM so_pedido WHERE id=? LIMIT 1');
    $st->execute([$id]);
    $code = $st->fetchColumn();
    if ($code) {
        echo $code, PHP_EOL;
        exit(0);
    }
    fwrite(STDERR, "No existe so_pedido id=$id\n");
    exit(1);
}

$rows = $pdo->query('SELECT id, codigo, created_at FROM so_pedido ORDER BY id DESC LIMIT 10')->fetchAll(PDO::FETCH_ASSOC);
foreach ($rows as $r) {
    printf("%6d  %-30s  %s\n", (int)$r['id'], (string)$r['codigo'], (string)($r['created_at'] ?? ''));
}
