# scripts/publish_github.ps1
# Helper script with safe, copy-pasteable commands to publish the current project to GitHub
# This script does NOT execute remote creation by itself; review commands before running.

# 1) Ensure you're in the project root
Push-Location -LiteralPath (Split-Path -Path $MyInvocation.MyCommand.Definition -Parent)\.. | Out-Null

Write-Host "Make sure .gitignore contains vendor/, node_modules/, public/assets/ and .env" -ForegroundColor Yellow
Write-Host "Commands to run (copy/paste):`n" -ForegroundColor Green

$cmds = @(
  'git init',
  'git add .',
  'git commit -m "Initial import"',
  '# Create GitHub repo (example using GitHub CLI):',
  'gh repo create <your-user-or-org>/sol --public --source=. --remote=origin',
  'git push -u origin main'
)
$cmds | ForEach-Object { Write-Host "  $_" }

Write-Host "\nIf you need to remove local folders before committing (destructive), you can run:" -ForegroundColor Yellow
Write-Host "  rm -r vendor node_modules public/assets public/assets1" -ForegroundColor Cyan

Pop-Location | Out-Null
