<?php
// Utility script to purge development data while keeping parameters, sys tables, and warehouse layout tables.
declare(strict_types=1);

$ROOT = dirname(__DIR__);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

$pdo = get_pdo();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$tablesToDrop = [
    '_nums',
    'inv09_lotes_map',
    'inv09_normalized',
    'inv09_pallet_moves',
    'inv09_sp_map',
];

$protectedPrefixes = ['para_', 'sys_'];
$protectedExact = [
    'wh_ambiente',
    'wh_deposito',
    'wh_posicion',
    'wh_pallet_estado',
    'migrations',
];

$pdo->exec('SET FOREIGN_KEY_CHECKS = 0');

// Drop auxiliary staging tables if they exist.
foreach ($tablesToDrop as $tableName) {
    $pdo->exec(sprintf('DROP TABLE IF EXISTS `%s`', $tableName));
}

// Build exclusion list placeholders for the prepared query.
$placeholders = [];
$params = [];
if ($protectedExact !== []) {
    $placeholders = array_fill(0, count($protectedExact), '?');
    $params = $protectedExact;
}

$sql = "SELECT TABLE_NAME
          FROM information_schema.TABLES
         WHERE TABLE_SCHEMA = DATABASE()
           AND TABLE_TYPE = 'BASE TABLE'
           AND TABLE_NAME NOT REGEXP '^(para_|sys_)'";

if ($placeholders !== []) {
    $sql .= ' AND TABLE_NAME NOT IN (' . implode(',', $placeholders) . ')';
}

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$tables = $stmt->fetchAll(PDO::FETCH_COLUMN);

foreach ($tables as $tableName) {
    $pdo->exec(sprintf('TRUNCATE TABLE `%s`', $tableName));
}

$pdo->exec('SET FOREIGN_KEY_CHECKS = 1');

echo "Dropped staging tables and truncated " . count($tables) . " tables.\n";
