<?php
// scripts/run_layout_builder_cli.php
// Emula un POST al formulario de public/tools/layout_builder.php para crear posiciones desde CLI
declare(strict_types=1);

// Ajustar cwd al root del proyecto
chdir(__DIR__ . '/..');

// Iniciar sesión y forzar usuario con permisos
if (session_status() === PHP_SESSION_NONE) session_start();
$_SESSION['usuario_id'] = 1; // asegúrate que el id exista o que no haya verificaciones adicionales

// Simular un POST: modifica estos valores según necesites
$payload = [
    'deposito_id' => 1,
    'racks' => 3,
    'cols' => 3,
    'niveles' => 2,
    'fondos' => 1,
    'capacidad' => 1,
    'orientacion' => 'N',
    'ambiente_id' => 0,
    'use_amb_capacity' => 0,
    'amb_capacity_override' => '',
    'save_amb_preset' => 0,
    'nota' => 'Generado por scripts/run_layout_builder_cli.php',
    'dry_run' => 0,
    'update_existing' => 1
];

// Populate $_POST and server method
$_SERVER['REQUEST_METHOD'] = 'POST';
$_POST = $payload;

// Capture la salida HTML (el script imprime la página y el feedback)
ob_start();
include __DIR__ . '/../public/tools/layout_builder.php';
$html = ob_get_clean();

// Buscar indicadores de resultado en el HTML (alerta con conteos)
if (preg_match('/Insertados:\s*(\d+)/i', $html, $m)) {
    $inserted = (int)$m[1];
} else {
    $inserted = null;
}
if (preg_match('/Actualizados:\s*(\d+)/i', $html, $m2)) {
    $updated = (int)$m2[1];
} else {
    $updated = null;
}
if (preg_match('/Errores:\s*(\d+)/i', $html, $m3)) {
    $errors = (int)$m3[1];
} else {
    $errors = null;
}

// Mostrar resultado resumido
echo "Layout Builder CLI run\n";
echo "Deposit id: " . $payload['deposito_id'] . "\n";
echo "Racks x Cols x Niveles x Fondos = {$payload['racks']} x {$payload['cols']} x {$payload['niveles']} x {$payload['fondos']}\n";
if ($inserted !== null || $updated !== null) {
    echo "Resultado: Insertados: " . ($inserted ?? 0) . " · Actualizados: " . ($updated ?? 0) . " · Errores: " . ($errors ?? 0) . "\n";
} else {
    // fallback: intentar extraer feedback en JSON si existiera
    if (preg_match('/<div class="alert alert-success">(.*?)<\/div>/is', $html, $succ)) {
        $txt = strip_tags($succ[1]);
        echo "Resultado (raw): " . trim($txt) . "\n";
    } else {
        echo "No se pudo extraer conteos del HTML. Muestra parcial:\n";
        echo substr($html, 0, 4000) . "\n";
    }
}

// Guardar HTML en temp para inspección
$tmpf = sys_get_temp_dir() . DIRECTORY_SEPARATOR . 'layout_builder_cli_result.html';
file_put_contents($tmpf, $html);
echo "HTML completo guardado en: $tmpf\n";

exit(0);
