<?php
// scripts/run_layout_builder_direct.php
// Ejecuta directamente el bucle de inserción del layout builder y muestra errores por fila.
declare(strict_types=1);
require_once __DIR__ . '/../config/db.php';
$pdo = getPDO();

// Params (adjust as needed)
$deposito_id = 1;
$racks = 3; $cols = 3; $niveles = 2; $fondos = 1;
$cap = 1; $orient = 'N'; $ambiente_id = 2; // use existing ambiente id (e.g., 2 = SECO)
$nota = 'CLI direct run (ambiente_id=2)';
$updateExisting = true;
$uid = 1;

// determine table/columns
$table = 'wh_posicion';
$wantedCols = ['deposito_id','rack','columna','nivel','fondo','orientacion','ambiente_id','capacidad_pallets','activo','title','code','code_full','pos_code','pos_code_full','created_at','created_by','updated_at','updated_by'];
$existing = [];
foreach ($wantedCols as $c) {
    $st = $pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = ?");
    $st->execute([$table, $c]);
    if ((int)$st->fetchColumn() > 0) $existing[] = $c;
}

if (empty($existing)) { echo "No se detectaron columnas en $table\n"; exit(2); }

// Build SQL same way as layout_builder
// Exclude updated_at/updated_by from VALUES (they are only used in ON DUPLICATE)
$existingValues = array_filter($existing, function($c){ return !in_array($c, ['updated_at','updated_by']); });
$colsSql = implode(', ', array_map(function($c){ return "`$c`"; }, $existingValues));
$placeholders = [];
foreach ($existingValues as $c) { $placeholders[] = $c === 'created_at' ? 'NOW()' : ':' . $c; }
$valsSql = implode(', ', $placeholders);

if ($updateExisting) {
    $upSets = [];
    foreach ($existing as $c) {
        if (in_array($c, ['created_at','created_by'])) continue;
        if ($c === 'updated_at') { $upSets[] = "updated_at = NOW()"; continue; }
        $upSets[] = "`$c` = VALUES(`$c`)";
    }
    $onDup = !empty($upSets) ? 'ON DUPLICATE KEY UPDATE ' . implode(', ', $upSets) : '';
    $sql = "INSERT INTO `$table` ($colsSql) VALUES ($valsSql) $onDup";
} else {
    $sql = "INSERT IGNORE INTO `$table` ($colsSql) VALUES ($valsSql)";
}

echo "SQL: $sql\n";
$stmt = $pdo->prepare($sql);

$inserted = $updated = $skipped = $errs = 0; $errsMsg = [];
for ($ri=1;$ri<=$racks;$ri++) {
  for ($ci=1;$ci<=$cols;$ci++) {
    for ($ni=1;$ni<=$niveles;$ni++) {
      for ($fi=1;$fi<=$fondos;$fi++) {
    // index -> letters helper (1->A, 27->AA)
    $indexToLetters = function($n) {
      $s = '';
      while ($n > 0) {
        $n--;
        $s = chr(65 + ($n % 26)) . $s;
        $n = intdiv($n, 26);
      }
      return $s;
    };

    $rackLetter = $indexToLetters($ri);
    $colLetter = $indexToLetters($ci);
    $rackCode = 'R' . $rackLetter;
    $colCode = 'C' . $colLetter;
        $nivCode = sprintf('N%02d',$ni);
        $fCode = sprintf('F%02d',$fi);
        $code = "$rackCode-$colCode-$nivCode-$fCode";
        $code_full = "DEP1-$code";
        $posCap = max(1, (int)$cap);

        $params = [];
        foreach ($existing as $c) {
          switch ($c) {
            case 'deposito_id': $params[':deposito_id'] = $deposito_id; break;
            case 'rack': $params[':rack'] = $ri; break;
            case 'columna': $params[':columna'] = $ci; break;
            case 'nivel': $params[':nivel'] = $ni; break;
            case 'fondo': $params[':fondo'] = $fi; break;
            case 'orientacion': $params[':orientacion'] = $orient; break;
            case 'ambiente_id': $params[':ambiente_id'] = $ambiente_id; break;
            case 'capacidad_pallets': $params[':capacidad_pallets'] = $posCap; break;
            case 'activo': $params[':activo'] = 1; break;
            case 'title': $params[':title'] = $nota; break;
            case 'code': $params[':code'] = $code; break;
            case 'code_full': $params[':code_full'] = $code_full; break;
            case 'pos_code': $params[':pos_code'] = $code; break;
            case 'pos_code_full': $params[':pos_code_full'] = $code_full; break;
            case 'created_by': $params[':created_by'] = $uid; break;
            default: break;
          }
        }

        try {
          $stmt->execute($params);
          $rc = $stmt->rowCount();
          if ($rc===1) $inserted++; elseif ($rc===2) $updated++; else $skipped++;
        } catch (Throwable $e) {
          $errs++;
          $errsMsg[] = "Pos $code -> " . $e->getMessage();
        }
      }
    }
  }
}

echo "Inserted: $inserted Updated: $updated Skipped: $skipped Errors: $errs\n";
if ($errs) {
  echo "Some errors (first 20):\n";
  foreach (array_slice($errsMsg,0,20) as $em) echo $em . "\n";
}

exit(0);
