<?php
// Test the simple endpoint
$testCode = '
<?php
require "scripts/simple_test_endpoint.php";
';

$tempFile = tempnam(sys_get_temp_dir(), 'test_simple_');
file_put_contents($tempFile, $testCode);

$result = shell_exec("cd " . escapeshellarg(__DIR__) . " && php " . escapeshellarg($tempFile) . " 2>&1");
unlink($tempFile);

echo "Simple Endpoint Test Result:\n";
echo "============================\n";
echo $result;

// Try to parse JSON
$jsonStart = strrpos($result, '{');
if ($jsonStart !== false) {
    $jsonPart = substr($result, $jsonStart);
    $data = json_decode($jsonPart, true);
    
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "\n✅ Parsed JSON successfully:\n";
        if ($data['ok']) {
            echo "   - Status: SUCCESS\n";
            echo "   - Count: " . $data['count'] . "\n";
            echo "   - Message: " . $data['message'] . "\n";
        } else {
            echo "   - Status: ERROR\n";
            echo "   - Error: " . $data['error'] . "\n";
            echo "   - File: " . $data['file'] . "\n";
            echo "   - Line: " . $data['line'] . "\n";
        }
    }
}