<?php
// Simple test endpoint
session_start();
$_SESSION['usuario_id'] = 1;

header('Content-Type: application/json; charset=utf-8');

try {
    require_once __DIR__ . '/../config/db.php';
    $pdo = getPDO();
    
    $sql = "
        SELECT 
            e.id,
            e.codigo,
            DATE(COALESCE(e.carga_fecha, e.creado_at)) as fecha_embarque,
            est.code as estado_code,
            est.nombre as estado_nombre
        FROM so_embarque e
        LEFT JOIN so_embarque_estado est ON est.id = e.estado_id
        ORDER BY e.creado_at DESC
        LIMIT 5
    ";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $embarques = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'ok' => true,
        'count' => count($embarques),
        'data' => $embarques,
        'message' => 'Simple test successful'
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'error' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ], JSON_UNESCAPED_UNICODE);
}