<?php
// scripts/sp_call_min.php
// Runner mínimo para CALL sp_so_preparar_auto con control de simulate/direct/log y streaming de resultados.
// Uso:
//   php scripts/sp_call_min.php --code=SO-... --dep=DEP1 --simulate --direct --timeout=60 --cands=200

declare(strict_types=1);
require_once __DIR__ . '/../config/db.php';

function opt(string $k, $def=null) { static $o; if (!$o) $o=getopt('', ['id::','code::','dep::','pos::','simulate','direct','log','timeout::','cands::']); return array_key_exists($k, $o) ? $o[$k] : $def; }

$soId   = opt('id');
$soCode = opt('code');
$dep    = opt('dep', 'DEP1');
$pos    = opt('pos');
$sim    = array_key_exists('simulate', getopt('', ['simulate'])) ? 1 : 0;
$direct = array_key_exists('direct',   getopt('', ['direct']))   ? 1 : 0;
$log    = array_key_exists('log',      getopt('', ['log']))      ? 1 : 0;
$timeout= (int)opt('timeout', 60);
$cands  = opt('cands');

$pdo = getPDO();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_0900_ai_ci");
$pdo->exec("SET collation_connection = 'utf8mb4_0900_ai_ci'");
$pdo->exec('SET SESSION innodb_lock_wait_timeout = ' . $timeout);
$pdo->exec('SET SESSION lock_wait_timeout = ' . $timeout);
$pdo->exec('SET SESSION transaction_isolation = "READ-COMMITTED"');
$pdo->exec('SET SESSION autocommit = 1');

if (!$soCode) {
    if (!$soId) die("Debe indicar --id o --code\n");
    $st = $pdo->prepare('SELECT codigo FROM so_pedido WHERE id=? LIMIT 1');
    $st->execute([(int)$soId]);
    $soCode = (string)$st->fetchColumn();
    if (!$soCode) die("Pedido id=$soId no encontrado\n");
}

$pdo->exec('SET @so_pre_log := ' . (int)$log);
$pdo->exec('SET @so_pre_direct_to_prep := ' . (int)$direct);
if ($cands !== null) $pdo->exec('SET @so_pre_max_cands := ' . (int)$cands);

echo "CALL sp_so_preparar_auto($soCode, $dep, ".($pos?:'NULL').", sim=$sim)\n";
$start = microtime(true);
try {
    $stmt = $pdo->prepare('CALL sp_so_preparar_auto(?,?,?,?)');
    $stmt->execute([$soCode, $dep, $pos, $sim]);
    $set=0; $totalRows=0;
    do {
        $i=0;
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            if ($i===0) { $set++; echo "-- SET $set --\n"; }
            $i++; $totalRows++;
            // imprimir primeras filas solamente para no inundar
            if ($i<=5) echo json_encode($row, JSON_UNESCAPED_UNICODE), "\n";
        }
    } while ($stmt->nextRowset());
    $stmt->closeCursor();
    $sec = round(microtime(true)-$start,3);
    echo "OK en {$sec}s, sets=$set, filas=$totalRows\n";
} catch (Throwable $e) {
    $sec = round(microtime(true)-$start,3);
    fwrite(STDERR, "ERROR tras {$sec}s: ".$e->getMessage()."\n");
    exit(1);
}
