<?php
// CLI: php scripts/sp_preparar_diag.php SO-YYYYmmdd-HHMMSS DEP1 --simulate
declare(strict_types=1);

require_once __DIR__ . '/../config/db.php';

function param(string $name, int $i, $def=null){ global $argv; return $argv[$i] ?? $def; }

$pedido = param('pedido', 1, null);
$dep    = param('dep', 2, 'DEP1');
$sim    = in_array('--simulate', $argv, true) ? 1 : 0;
$log    = in_array('--log', $argv, true) ? 1 : 0;

if (!$pedido) {
    fwrite(STDERR, "Uso: php scripts/sp_preparar_diag.php SO-... [DEP1] [--simulate] [--log]\n");
    exit(2);
}

$pdo = getPDO();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_0900_ai_ci");
$pdo->exec("SET collation_connection = 'utf8mb4_0900_ai_ci'");
$pdo->exec('SET @so_pre_log := ' . (int)$log);

// Resolve so_id
$soId = (int)($pdo->query("SELECT id FROM so_pedido WHERE codigo=" . $pdo->quote($pedido) . " LIMIT 1")->fetchColumn() ?: 0);
if ($soId <= 0) { fwrite(STDERR, "Pedido no encontrado\n"); exit(1); }

$stmt = $pdo->prepare('CALL sp_so_preparar_auto(?,?,?,?)');
$stmt->execute([$pedido, $dep, null, $sim]);

$i = 0;
do {
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if ($rows) {
        echo "-- Result set #" . (++$i) . " --\n";
        echo json_encode($rows, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
    }
} while ($stmt->nextRowset());
$stmt->closeCursor();

echo "OK\n";
// end of file