<?php
$ROOT = dirname(__DIR__);
$options = getopt('', ['file::']);
$diffFile = $options['file'] ?? ($ROOT . '/tmp/schema_compare_sol.old_after_sync.json');
if (!preg_match('#^(?:[A-Za-z]:[\\/]|/)#', $diffFile)) {
    $diffFile = $ROOT . '/' . ltrim($diffFile, '/\\');
}
if (!is_file($diffFile)) {
    fwrite(STDERR, "Diff file not found: $diffFile\n");
    exit(1);
}
$payload = json_decode(file_get_contents($diffFile), true);
if (!is_array($payload)) {
    fwrite(STDERR, "Unable to decode diff JSON\n");
    exit(1);
}
$comparison = $payload['comparison'] ?? [];
if ($comparison === []) {
    fwrite(STDOUT, "No comparison data found.\n");
    exit(0);
}

$intentionalRetired = [
    'wh_bin',
    'wh_bin_attr',
    'wh_bin_tipo',
    'wh_columna',
    'wh_fondo',
    'wh_lado',
    'wh_nivel',
    'wh_orientacion',
    'wh_rack',
    'wh_move_items',
    'ope_ingresos',
    'pl_import_batches',
    'pl_import_rows',
    'vw_wh_moves_duracion',
];

$intentionalDivergent = [
    'wh_moves',
    'wh_pallet_items',
    'wh_pallets',
    'wh_position_occupancy',
    'wh_positions',
];

echo "=== Remaining Schema Differences vs {$comparison['schema']} ===\n\n";

$missingInCurrent = $comparison['missing_in_current'] ?? [];
$missingInCompare = $comparison['missing_in_compare'] ?? [];
$missingIntentional = array_values(array_intersect($missingInCurrent, $intentionalRetired));
$missingInCurrent = array_values(array_diff($missingInCurrent, $intentionalRetired));
if ($missingInCurrent !== []) {
    echo "Tables present in {$comparison['schema']} but missing in current schema:\n";
    foreach ($missingInCurrent as $table) {
        echo "  - $table\n";
    }
    echo "\n";
}
if ($missingIntentional !== []) {
    echo "Tables intentionally retired or replaced (tracked for legacy awareness):\n";
    foreach ($missingIntentional as $table) {
        echo "  - $table\n";
    }
    echo "\n";
}
if ($missingInCompare !== []) {
    echo "Tables new in current schema (absent in {$comparison['schema']}):\n";
    foreach ($missingInCompare as $table) {
        echo "  - $table\n";
    }
    echo "\n";
}

$columnDiffs = $comparison['column_differences'] ?? [];
if ($columnDiffs !== []) {
    foreach ($columnDiffs as $table => $diff) {
        $isIntentional = in_array($table, $intentionalDivergent, true);
        echo "Table $table:\n";
        $missingCurrent = $diff['missing_in_current'] ?? [];
        $missingCompare = $diff['missing_in_compare'] ?? [];
        $mismatched = $diff['mismatched'] ?? [];
        if ($missingCurrent !== []) {
            echo "  Columns missing here (only in {$comparison['schema']}): " . implode(', ', $missingCurrent) . "\n";
        }
        if ($missingCompare !== []) {
            echo "  New columns here (missing in {$comparison['schema']}): " . implode(', ', $missingCompare) . "\n";
        }
        if ($mismatched !== []) {
            foreach ($mismatched as $column => $attributes) {
                echo "  Column $column attribute differences:\n";
                foreach ($attributes as $attribute => $values) {
                    $current = $values['current'] === null ? 'NULL' : $values['current'];
                    $legacy = $values['compare'] === null ? 'NULL' : $values['compare'];
                    echo "    - $attribute: current={$current} | legacy={$legacy}\n";
                }
            }
        }
        if ($isIntentional) {
            echo "  *Note*: divergence accepted as part of compatibility view mapping.\n";
        }
        echo "\n";
    }
}

echo "Summary complete.\n";
