<?php
// Simular exactamente la petición AJAX
$_POST = []; // Limpiar POST
$input = json_encode([
    'so_id' => 19,
    'deposito_code' => 'DEP1', 
    'prep_posicion_id' => 3,
    'debug' => 0,
    'simulate' => 0
]);

// Simular el input stream
file_put_contents('php://temp', $input);

// Configurar el entorno como si fuera una petición real
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['CONTENT_TYPE'] = 'application/json; charset=utf-8';

// Capturar el output
ob_start();

try {
    // Incluir el endpoint
    include 'api/operaciones/so_preparar_auto.php';
    $output = ob_get_clean();
    
    echo "=== RESPUESTA DEL ENDPOINT ===\n";
    echo $output . "\n";
    echo "=== FIN RESPUESTA ===\n";
    
    // Verificar si es JSON válido
    $decoded = json_decode($output, true);
    if ($decoded !== null) {
        echo "JSON válido: " . (isset($decoded['ok']) ? ($decoded['ok'] ? 'SUCCESS' : 'ERROR') : 'UNKNOWN') . "\n";
        if (isset($decoded['error'])) {
            echo "Error: " . $decoded['error'] . "\n";
        }
    } else {
        echo "ERROR: Respuesta no es JSON válido\n";
        echo "JSON Error: " . json_last_error_msg() . "\n";
    }
    
} catch (Exception $e) {
    ob_end_clean();
    echo "EXCEPCIÓN: " . $e->getMessage() . "\n";
}
?>