<?php
/**
 * Test directo del endpoint de Cumplimiento de Entregas
 */

$BASE = dirname(__DIR__);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';

// Simular sesión de usuario para el test
$_SESSION['usuario_id'] = 1;

try {
    $pdo = getPDO();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Simular parámetros GET
    $_GET = [
        'fecha_desde' => '2024-01-01',
        'fecha_hasta' => '2026-12-31'
    ];

    // Incluir el endpoint
    ob_start();
    include $BASE . '/api/reportes/embarque_cumplimiento.php';
    $result = ob_get_clean();

    echo "✅ Endpoint ejecutado exitosamente\n";
    echo "📊 Resultado completo:\n";
    echo $result . "\n\n";
    
    $data = json_decode($result, true);
    if ($data) {
        echo "- Status: " . ($data['ok'] ? 'OK' : 'ERROR') . "\n";
        echo "- Total registros: " . count($data['data'] ?? []) . "\n";
        echo "- Filtros aplicados:\n";
        foreach ($data['filtros'] ?? [] as $key => $value) {
            echo "  - {$key}: {$value}\n";
        }
        if (!empty($data['data'][0])) {
            echo "- Primera muestra:\n";
            foreach ($data['data'][0] as $key => $value) {
                echo "  - {$key}: " . (is_null($value) ? 'NULL' : $value) . "\n";
            }
        }
    } else {
        echo "❌ No se pudo decodificar JSON\n";
        echo $result . "\n";
    }

} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "📍 File: " . $e->getFile() . " line " . $e->getLine() . "\n";
    if ($e->getPrevious()) {
        echo "🔗 Previous: " . $e->getPrevious()->getMessage() . "\n";
    }
}