<?php
// scripts/test_cumplimiento_simple.php
declare(strict_types=1);

// Start output buffering before any output
ob_start();

// Prevent headers from being sent
if (!headers_sent()) {
    header_remove(); // Clear any pending headers
}

echo "Testing Cumplimiento API endpoint...\n";
echo "Date range: " . date('Y-m-d', strtotime('-7 days')) . " to " . date('Y-m-d') . "\n\n";

$output = ob_get_clean();
echo $output;

// Mock session and GET parameters in a separate context
$testCode = '
<?php
session_start();
$_SESSION["usuario_id"] = 1;
$_SESSION["usuario_nombre"] = "Test User";
$_GET["fecha_desde"] = "' . date('Y-m-d', strtotime('-7 days')) . '";
$_GET["fecha_hasta"] = "' . date('Y-m-d') . '";

try {
    require "api/reportes/embarque_cumplimiento.php";
} catch (Throwable $e) {
    echo json_encode(["ok" => false, "error" => $e->getMessage()]);
}
';

// Write to temp file and execute
$tempFile = tempnam(sys_get_temp_dir(), 'test_cumplimiento_');
file_put_contents($tempFile, $testCode);

// Execute in separate process to avoid header conflicts
$result = shell_exec("cd " . escapeshellarg(__DIR__ . '/..') . " && php " . escapeshellarg($tempFile) . " 2>&1");
unlink($tempFile);

echo "API Response:\n";
echo "=============\n";

if ($result) {
    // Extract just the JSON part (ignore any warnings)
    $jsonStart = strrpos($result, '{');
    if ($jsonStart !== false) {
        $jsonPart = substr($result, $jsonStart);
        $data = json_decode($jsonPart, true);
        
        if (json_last_error() === JSON_ERROR_NONE) {
            if (isset($data['ok']) && $data['ok'] === true) {
                echo "✅ Success!\n";
                echo "📊 Found " . count($data['data']) . " embarques\n";
                
                if (isset($data['metrics'])) {
                    echo "📈 Metrics:\n";
                    echo "   - Total embarques: " . $data['metrics']['total_embarques'] . "\n";
                    echo "   - Rate cumplimiento: " . $data['metrics']['fulfillment_rates']['rate_cumplimiento'] . "%\n";
                    echo "   - Rate entrega parcial: " . $data['metrics']['fulfillment_rates']['rate_entrega_parcial'] . "%\n";
                }
                
                if (isset($data['filter_options'])) {
                    echo "🔧 Filter options loaded:\n";
                    echo "   - Estados: " . count($data['filter_options']['estados']) . "\n";
                    echo "   - Clientes: " . count($data['filter_options']['clientes']) . "\n";
                    echo "   - Destinatarios: " . count($data['filter_options']['destinatarios']) . "\n";
                    echo "   - Móviles: " . count($data['filter_options']['moviles']) . "\n";
                }
                
                echo "\n🎉 Cumplimiento endpoint is working correctly!\n";
            } else {
                echo "❌ API returned error: " . ($data['error'] ?? 'Unknown') . "\n";
            }
        } else {
            echo "❌ Invalid JSON in response\n";
            echo "JSON part: " . substr($jsonPart, 0, 500) . "\n";
        }
    } else {
        echo "❌ No JSON found in response\n";
        echo "Raw output:\n" . substr($result, 0, 1000) . "\n";
    }
} else {
    echo "❌ No output from script\n";
}