<?php
// scripts/test_embarque_monitoreo.php
declare(strict_types=1);

require_once __DIR__ . '/../config/db.php';

echo "Testing Embarque Monitoreo API...\n";

try {
    $pdo = getPDO();
    
    // Test database connection and check if tables exist
    echo "1. Testing database connection... ";
    $tables = ['so_embarque', 'so_embarque_estado', 'para_moviles', 'para_choferes', 'wh_deposito'];
    
    foreach ($tables as $table) {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() === 0) {
            echo "FAIL\n   Table '$table' does not exist!\n";
            exit(1);
        }
    }
    echo "OK\n";
    
    // Test basic query structure
    echo "2. Testing basic query structure... ";
    $sql = "
        SELECT 
            e.id,
            e.codigo,
            e.creado_at,
            est.code as estado_code,
            est.nombre as estado,
            dep.code as deposito_code
        FROM so_embarque e
        LEFT JOIN so_embarque_estado est ON est.id = e.estado_id
        LEFT JOIN wh_deposito dep ON dep.id = e.deposito_id
        LIMIT 1
    ";
    
    $stmt = $pdo->query($sql);
    echo "OK\n";
    
    // Test API endpoint simulation
    echo "3. Testing API logic simulation... ";
    
    // Get some sample data
    $stmt = $pdo->query("SELECT COUNT(*) FROM so_embarque");
    $totalEmbarques = $stmt->fetchColumn();
    echo "Total embarques in DB: $totalEmbarques\n";
    
    // Test estados
    $stmt = $pdo->query("SELECT code, nombre FROM so_embarque_estado ORDER BY orden");
    $estados = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "   Available estados: " . implode(', ', array_column($estados, 'code')) . "\n";
    
    // Test moviles
    $stmt = $pdo->query("SELECT COUNT(*) FROM para_moviles WHERE activo = 1");
    $totalMoviles = $stmt->fetchColumn();
    echo "   Active moviles: $totalMoviles\n";
    
    // Test choferes
    $stmt = $pdo->query("SELECT COUNT(*) FROM para_choferes WHERE activo = 1");
    $totalChoferes = $stmt->fetchColumn();
    echo "   Active choferes: $totalChoferes\n";
    
    echo "4. API simulation complete - all checks passed!\n";
    
    echo "\nYou can now test the API endpoint at:\n";
    echo "   GET /api/reportes/embarque_monitoreo.php\n";
    echo "   Or access the view at:\n";
    echo "   GET /reportes/embarques_monitoreo\n";
    
} catch (Exception $e) {
    echo "FAIL\n";
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}