<?php
// scripts/test_endpoint.php
// Usage examples:
//   php scripts/test_endpoint.php GET  api/operaciones/so_items.php "so_id=16"
//   php scripts/test_endpoint.php POST api/operaciones/so_preparar_auto.php "so_id=16&deposito_code=DEP1&prep_posicion_id=3&debug=1"
declare(strict_types=1);
if ($argc < 3) { echo "Usage: php scripts/test_endpoint.php METHOD path [query]\n"; exit(1); }
$method = strtoupper($argv[1]);
$path = $argv[2];
$query = $argv[3] ?? '';
$_GET = [];
$_POST = [];
$_SERVER['REQUEST_METHOD'] = in_array($method, ['GET','POST']) ? $method : 'GET';
if ($method === 'GET') {
	parse_str($query, $_GET);
} else {
	parse_str($query, $_POST);
	$_SERVER['CONTENT_TYPE'] = 'application/x-www-form-urlencoded';
}
// Rebuild $_REQUEST so endpoints reading $_REQUEST get the injected params
$_REQUEST = array_merge($_GET, $_POST);
ob_start();
include __DIR__ . '/../' . ltrim($path, '/\\');
$out = ob_get_clean();
echo substr($out, 0, 4096) . (strlen($out) > 4096 ? "\n...truncated..." : "\n");
