<?php
require_once 'config/config.php';
require_once 'config/db.php';

// Simular exactamente lo que hace el endpoint
$soId = 19;
$soCodigo = 'SO-20251014-134910';
$depCode = 'DEP1';
$prepPosCode = null;
$simulate = 0;

try {
    echo "Iniciando test completo del endpoint...\n";
    
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec('SET NAMES utf8mb4');

    echo "1. Ejecutando SP...\n";
    $stmt = $pdo->prepare('CALL sp_so_preparar_auto(?,?,?,?)');
    $stmt->execute([$soCodigo, $depCode, $prepPosCode, $simulate]);
    
    // Recoger resultsets
    $sets = [];
    do {
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($rows !== false && $rows) $sets[] = $rows;
    } while ($stmt->nextRowset());
    $resumen = $sets ? end($sets) : [];
    
    echo "2. SP completado, resultsets: " . count($sets) . "\n";

    echo "3. Obteniendo datos de preembarque...\n";
    $preCode = 'PRE-' . $soCodigo;
    $stPre = $pdo->prepare('SELECT id, zona_posicion_id FROM so_preembarque WHERE codigo=? LIMIT 1');
    $stPre->execute([$preCode]);
    $pre = $stPre->fetch(PDO::FETCH_ASSOC) ?: null;
    
    if ($pre) {
        echo "4. Preembarque encontrado: ID = " . $pre['id'] . "\n";
        
        echo "5. Actualizando estado del pedido...\n";
        
        // Esta es la parte que agregamos - puede estar causando el problema
        if (!$simulate && $soId > 0) {
            $stEstado = $pdo->prepare('SELECT id FROM so_pedido_estado WHERE code=? LIMIT 1');
            $stEstado->execute(['REPOSICION']);
            $estadoReposicionId = $stEstado->fetchColumn();
            
            echo "6. Estado REPOSICION ID: " . ($estadoReposicionId ?: 'NO ENCONTRADO') . "\n";
            
            if ($estadoReposicionId) {
                $stUpdate = $pdo->prepare('UPDATE so_pedido SET estado_id=? WHERE id=?');
                $stUpdate->execute([$estadoReposicionId, $soId]);
                echo "7. Estado actualizado exitosamente\n";
            } else {
                echo "7. ERROR: Estado REPOSICION no encontrado\n";
            }
        }
    } else {
        echo "4. ERROR: Preembarque no encontrado\n";
    }
    
    echo "Test completado exitosamente\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>