<?php
require_once 'config/db.php';
$pdo = getPDO();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Buscar productos involucrados en embarques
$sql = "
SELECT p.id, p.denominacion,
  COUNT(DISTINCT ep.embarque_id) as embarques,
  SUM(ep.uv_cajas) as total_uv,
  SUM(ep.uc_unidades) as total_uc
FROM para_productos p
LEFT JOIN so_embarque_pre ep ON ep.producto_id = p.id
WHERE ep.embarque_id IS NOT NULL
GROUP BY p.id, p.denominacion
ORDER BY total_uv DESC
LIMIT 10
";
$stmt = $pdo->query($sql);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
echo "KPIs de productos en embarques:\n";
foreach ($rows as $row) {
    echo "Producto: {$row['denominacion']} | Embarques: {$row['embarques']} | UV: {$row['total_uv']} | UC: {$row['total_uc']}\n";
}
