<?php
require_once 'config/db.php';

try {
    echo "Probando endpoint so_preparar_auto...\n";
    
    // Simular la llamada al endpoint
    $soId = 19; // El que vimos antes
    
    echo "Probando con so_id: $soId\n";
    
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Verificar que existe el pedido
    $stmt = $pdo->prepare('SELECT codigo FROM so_pedido WHERE id=? LIMIT 1');
    $stmt->execute([$soId]);
    $soCodigo = $stmt->fetchColumn();
    
    if (!$soCodigo) {
        echo "ERROR: Pedido $soId no encontrado\n";
        exit;
    }
    
    echo "Pedido encontrado: $soCodigo\n";
    
    // Verificar que existe el SP
    $chk = $pdo->query("SHOW PROCEDURE STATUS WHERE Name='sp_so_preparar_auto'")->fetch(PDO::FETCH_ASSOC);
    if (!$chk) {
        echo "ERROR: Stored procedure no existe\n";
        exit;
    }
    
    echo "Stored procedure existe\n";
    
    // Intentar ejecutar el SP con timeout
    ini_set('max_execution_time', 30); // 30 segundos máximo
    
    echo "Ejecutando SP...\n";
    $start = microtime(true);
    
    try {
        $stmt = $pdo->prepare('CALL sp_so_preparar_auto(?,?,?,?)');
        $stmt->execute([$soCodigo, 'DEP1', null, 0]);
        
        $end = microtime(true);
        echo "SP ejecutado exitosamente en " . round($end - $start, 2) . " segundos\n";
        
        // Recoger resultados
        $sets = [];
        do {
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if ($rows !== false && $rows) {
                $sets[] = $rows;
            }
        } while ($stmt->nextRowset());
        
        echo "Resultsets obtenidos: " . count($sets) . "\n";
        
    } catch (PDOException $e) {
        $end = microtime(true);
        echo "ERROR en SP después de " . round($end - $start, 2) . " segundos: " . $e->getMessage() . "\n";
    }
    
} catch (Exception $e) {
    echo "ERROR general: " . $e->getMessage() . "\n";
}
?>