<?php
require_once 'config/db.php';

echo "=== PRUEBA DEL PLAN FEFO PARA SO-28 ===\n\n";

try {
    $pdo = get_pdo();
    
    // 1. Verificar estado actual del pedido SO-28
    echo "1. ESTADO ACTUAL DEL PEDIDO SO-28:\n";
    $stmt = $pdo->prepare('
        SELECT p.*, e.code as estado_code, e.nombre as estado_nombre
        FROM so_pedido p 
        LEFT JOIN so_pedido_estado e ON e.id = p.estado_id 
        WHERE p.id = 28
    ');
    $stmt->execute();
    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($pedido) {
        echo "  Código: {$pedido['codigo']}\n";
        echo "  Estado: {$pedido['estado_code']} ({$pedido['estado_nombre']})\n";
        echo "  Cliente ID: {$pedido['cliente_id']}\n";
    } else {
        echo "  ❌ Pedido SO-28 no encontrado\n";
        exit;
    }
    
    // 2. Verificar items pendientes
    echo "\n2. ITEMS PENDIENTES:\n";
    $stmt = $pdo->prepare('
        SELECT 
            pr.sku, pr.denominacion,
            SUM(i.expected_uv) as expected_uv,
            SUM(i.expected_uc) as expected_uc,
            SUM(i.prepared_uv) as prepared_uv,
            SUM(i.prepared_uc) as prepared_uc,
            (SUM(i.expected_uv) - SUM(i.prepared_uv)) as pendiente_uv,
            (SUM(i.expected_uc) - SUM(i.prepared_uc)) as pendiente_uc
        FROM so_pedido_dest d 
        LEFT JOIN so_pedido_dest_item i ON i.pedido_dest_id = d.id 
        LEFT JOIN para_productos pr ON pr.id = i.producto_id
        WHERE d.pedido_id = 28
        GROUP BY pr.id, pr.sku, pr.denominacion
    ');
    $stmt->execute();
    $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($productos as $prod) {
        echo "  SKU: {$prod['sku']} ({$prod['denominacion']})\n";
        echo "    Esperado: {$prod['expected_uv']} UV + {$prod['expected_uc']} UC\n";
        echo "    Preparado: {$prod['prepared_uv']} UV + {$prod['prepared_uc']} UC\n";
        echo "    Pendiente: {$prod['pendiente_uv']} UV + {$prod['pendiente_uc']} UC\n";
    }
    
    // 3. Verificar stock disponible
    echo "\n3. STOCK DISPONIBLE:\n";
    if (!empty($productos)) {
        $productoId = null;
        $stmt = $pdo->prepare('SELECT id FROM para_productos WHERE sku = ?');
        $stmt->execute([$productos[0]['sku']]);
        $productoId = $stmt->fetchColumn();
        
        if ($productoId) {
            $stmt = $pdo->prepare('
                SELECT 
                    s.*, 
                    pos.code as posicion,
                    l.codigo as lote,
                    l.fecha_vencimiento
                FROM wh_stock s 
                LEFT JOIN wh_posicion pos ON pos.id = s.posicion_id
                LEFT JOIN wh_lote l ON l.id = s.lote_id
                WHERE s.producto_id = ? AND (s.qty_uv > 0 OR s.qty_uc > 0)
                ORDER BY l.fecha_vencimiento ASC
            ');
            $stmt->execute([$productoId]);
            $stocks = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($stocks as $stock) {
                echo "  Posición: {$stock['posicion']} | Lote: {$stock['lote']} | Venc: {$stock['fecha_vencimiento']}\n";
                echo "    Stock: {$stock['qty_uv']} UV + {$stock['qty_uc']} UC\n";
            }
        }
    }
    
    echo "\n4. LISTO PARA PLAN FEFO:\n";
    echo "  📍 Ir a: http://sol.test/salidas/preparacion?so_id=28\n";
    echo "  🔵 Hacer clic en: Plan FEFO\n";
    echo "  ⏱️ Esperar resultado (máximo 60 segundos)\n";
    echo "  📊 Observar cambio de estado y aparición de nuevos botones\n";
    
} catch (Throwable $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Archivo: " . $e->getFile() . "\n";
    echo "Línea: " . $e->getLine() . "\n";
}
?>