<?php
require __DIR__ . '/../config/db.php';
$pdo = getPDO();

echo "Testing simplified query step by step...\n";

// Step 1: Basic so_embarque query
try {
    echo "1. Testing basic so_embarque query...\n";
    $result = $pdo->query("SELECT id, codigo FROM so_embarque LIMIT 1");
    $row = $result->fetch();
    echo "   ✅ so_embarque accessible: {$row['codigo']}\n";
} catch (Exception $e) {
    echo "   ❌ so_embarque error: " . $e->getMessage() . "\n";
    exit(1);
}

// Step 2: Join with so_embarque_estado
try {
    echo "2. Testing join with so_embarque_estado...\n";
    $result = $pdo->query("
        SELECT e.codigo, est.nombre 
        FROM so_embarque e 
        LEFT JOIN so_embarque_estado est ON est.id = e.estado_id 
        LIMIT 1
    ");
    $row = $result->fetch();
    echo "   ✅ Join successful: {$row['codigo']} - {$row['nombre']}\n";
} catch (Exception $e) {
    echo "   ❌ Join error: " . $e->getMessage() . "\n";
    exit(1);
}

// Step 3: Test so_embarque_parada
try {
    echo "3. Testing so_embarque_parada subquery...\n";
    $result = $pdo->query("
        SELECT e.codigo,
               (SELECT COUNT(*) FROM so_embarque_parada p WHERE p.embarque_id = e.id) as total_destinos
        FROM so_embarque e 
        LIMIT 1
    ");
    $row = $result->fetch();
    echo "   ✅ Parada subquery successful: {$row['codigo']} has {$row['total_destinos']} destinos\n";
} catch (Exception $e) {
    echo "   ❌ Parada subquery error: " . $e->getMessage() . "\n";
}

// Step 4: Test so_embarque_pre  
try {
    echo "4. Testing so_embarque_pre subquery...\n";
    $result = $pdo->query("
        SELECT e.codigo,
               (SELECT COUNT(DISTINCT ep.preembarque_id) FROM so_embarque_pre ep WHERE ep.embarque_id = e.id) as pedidos
        FROM so_embarque e 
        LIMIT 1
    ");
    $row = $result->fetch();
    echo "   ✅ Pre subquery successful: {$row['codigo']} has {$row['pedidos']} pedidos\n";
} catch (Exception $e) {
    echo "   ❌ Pre subquery error: " . $e->getMessage() . "\n";
}

// Step 5: Test so_preembarque join
try {
    echo "5. Testing so_preembarque join...\n";
    $result = $pdo->query("
        SELECT e.codigo,
               (SELECT COUNT(DISTINCT ep.preembarque_id)
                FROM so_embarque_pre ep 
                WHERE ep.embarque_id = e.id 
                AND EXISTS (
                    SELECT 1 FROM so_preembarque sp 
                    WHERE sp.id = ep.preembarque_id 
                    AND sp.fin_at IS NOT NULL
                )) as despachados
        FROM so_embarque e 
        LIMIT 1
    ");
    $row = $result->fetch();
    echo "   ✅ Preembarque join successful: {$row['codigo']} has {$row['despachados']} despachados\n";
} catch (Exception $e) {
    echo "   ❌ Preembarque join error: " . $e->getMessage() . "\n";
}

echo "\n✅ All individual parts work! The full query should work.\n";