<?php
// scripts/test_recepcion_guardar_hdr.php
declare(strict_types=1);
if ($argc < 2) { echo "Usage: php scripts/test_recepcion_guardar_hdr.php PL_ID\n"; exit(1); }
$pl = (int)$argv[1];
$host = 'http://sol.test';
$url = rtrim($host, '/') . '/api/operaciones/recepcion.php?meta=recepcion_guardar_hdr';

$payload = [
    'pl_id' => $pl,
    'fecha_ingreso' => date('Y-m-d'),
    'hora_arribo' => date('H:i:s'),
    'movil_id' => 1,
    'chofer_id' => 1,
    'movil_desc' => 'TEST-POST',
    'chofer_desc' => 'CHOFER-TEST',
    'operarios_cant' => 3,
    'tipo_documento' => 'REMITO',
    'documento_entrada' => 'TEST-123',
    'observacion' => 'Prueba automática'
];

$opts = [
  'http' => [
    'method'  => 'POST',
    'header'  => "Content-Type: application/json\r\n",
    'content' => json_encode($payload),
    'timeout' => 10
  ]
];
$ctx = stream_context_create($opts);
$raw = @file_get_contents($url, false, $ctx);
if ($raw === false) {
  echo "Request failed\n";
  // show php errors from warnings
  $err = error_get_last();
  if ($err) echo "Error: " . $err['message'] . "\n";
  exit(2);
}

echo "--- Response ---\n";
echo $raw . "\n";
echo "--- End ---\n";

// Attempt to pretty decode
@json_decode($raw);
if (json_last_error() === JSON_ERROR_NONE) {
  echo "\n--- Decoded JSON ---\n";
  print_r(json_decode($raw, true));
}

exit(0);
