<?php
require_once __DIR__ . '/../config/db.php';

$pdo = get_pdo();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$q = '4437';

try {
    $sql = "
      SELECT
        COALESCE(cli.razon_social, CONCAT('Cliente #', pal.cliente_id)) AS cliente,
        p.sku,
        p.denominacion,
        SUM(COALESCE(pi.uc_unidades, 0)) AS ing_uc,
        SUM(COALESCE(pi.uv_cajas, 0))    AS ing_cajas,
        COUNT(DISTINCT m.id)             AS docs,
        MAX(DATE_FORMAT(m.created_at, '%Y-%m-%d %H:%i')) AS ultimo_in
      FROM wh_move m
      JOIN wh_pallet       pal ON pal.id = m.pallet_id
      JOIN wh_pallet_item  pi  ON pi.pallet_id = pal.id
      JOIN para_productos  p   ON p.id = pi.producto_id
      LEFT JOIN para_clientes cli ON cli.id = pal.cliente_id
      WHERE m.tipo='IN' AND (p.sku LIKE :q OR p.denominacion LIKE :q)
      GROUP BY pal.cliente_id, cli.razon_social, p.id
      ORDER BY cliente ASC, ing_uc DESC, p.sku ASC
    ";
    
    $st = $pdo->prepare($sql);
    $st->bindValue(':q', "%{$q}%");
    $st->execute();
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Query ejecutado correctamente\n";
    echo "Filas encontradas: " . count($rows) . "\n\n";
    print_r($rows);
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "SQL State: " . $e->getCode() . "\n";
}
