<?php
// scripts/test_recepcion_save.php
// Usage: php test_recepcion_save.php PL_ID
declare(strict_types=1);
if ($argc < 2) { echo "Usage: php scripts/test_recepcion_save.php PL_ID\n"; exit(1); }
$pl = (int)$argv[1];
if ($pl <= 0) { echo "Invalid PL ID\n"; exit(2); }

// Prepare a minimal payload: receive nothing (auto mode) but include metadata
$_GET['meta'] = 'recepcion_guardar';
$data = [
  'pl_id' => $pl,
  'deposito_code' => 'DEP1',
  'auto_ubicar' => true,
  // metadata example
  'fecha_ingreso' => date('Y-m-d'),
  'hora_arribo' => date('H:i'),
  'movil_id' => 1,
  'chofer_id' => 1,
  'movil_desc' => 'TEST-123',
  'chofer_desc' => 'Prueba Chofer'
];

// Simulate JSON input
$json = json_encode($data);
file_put_contents('php://temp', $json); // no-op but keep for clarity

// Provide input stream to endpoint by overriding php://input via stream wrapper is complex; instead, set a global function used by endpoint
// The endpoint uses getJsonInput() helper; ensure that function will read from our $data by defining it if missing.
if (!function_exists('getJsonInput')) {
  function getJsonInput() {
    global $data;
    return $data;
  }
}

// Include the endpoint which will read $_GET['meta'] and call the handler
ob_start();
include __DIR__ . '/../api/operaciones/recepcion.php';
$out = ob_get_clean();
echo substr($out,0,4000) . (strlen($out) > 4000 ? "\n...truncated..." : "\n");
