<?php
// scripts/test_reportes_routing.php
declare(strict_types=1);

require_once __DIR__ . '/../config/config.php';

echo "Testing Reportes Routing...\n";

// Test that the view files exist and have proper structure
$reports = [
    'embarques_monitoreo' => 'views/reportes/embarques_monitoreo/index.php',
    'embarques_tiempos' => 'views/reportes/embarques_tiempos/index.php',
    'embarques_cumplimiento' => 'views/reportes/embarques_cumplimiento/index.php',
    'embarques_devoluciones' => 'views/reportes/embarques_devoluciones/index.php',
    'almacenamiento' => 'views/reportes/almacenamiento/index.php',
];

foreach ($reports as $name => $path) {
    $fullPath = BASE_PATH . '/' . $path;
    echo "Checking $name... ";
    
    if (!file_exists($fullPath)) {
        echo "FAIL - File does not exist: $fullPath\n";
        continue;
    }
    
    // Check if file follows SOL pattern
    $content = file_get_contents($fullPath);
    if (strpos($content, "sol_section('page_title'") === false) {
        echo "WARNING - Missing sol_section for page_title\n";
    } elseif (strpos($content, "include project_path('views/layout/layout_app.php')") === false) {
        echo "WARNING - Missing layout include\n";
    } else {
        echo "OK\n";
    }
}

// Test that helper functions exist
echo "\nChecking helper functions... ";
$helpers = BASE_PATH . '/app/Support/ViewHelpers.php';
if (!file_exists($helpers)) {
    echo "FAIL - ViewHelpers.php not found\n";
} else {
    echo "OK\n";
}

echo "\nReportes routing test complete!\n";
echo "You can now access:\n";
echo "  - /reportes/embarques_monitoreo\n";
echo "  - /reportes/embarques_tiempos\n";
echo "  - /reportes/embarques_cumplimiento\n";
echo "  - /reportes/embarques_devoluciones\n";
echo "  - /reportes/almacenamiento\n";