<?php
require_once 'config/db.php';

echo "=== PRUEBA DEL ENDPOINT SIMPLIFICADO ===\n\n";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://sol.test/api/operaciones/so_preparar_simple.php');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
    'so_id' => 28,
    'simulate' => 0  // REAL
]));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);

echo "Ejecutando Plan FEFO simplificado...\n";
$start = microtime(true);
$response = curl_exec($ch);
$duration = microtime(true) - $start;
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "Tiempo total: " . round($duration, 2) . "s\n";
echo "HTTP Code: $httpCode\n";
if ($error) echo "cURL Error: $error\n";
echo "\nRespuesta:\n$response\n";

// Decodificar respuesta
if ($response) {
    $decoded = json_decode($response, true);
    if ($decoded) {
        echo "\n=== ANÁLISIS DE RESPUESTA ===\n";
        echo "Éxito: " . ($decoded['ok'] ? 'SÍ' : 'NO') . "\n";
        if (isset($decoded['duration'])) {
            echo "Duración SP: {$decoded['duration']}s\n";
        }
        if (isset($decoded['result_sets'])) {
            echo "Result sets: {$decoded['result_sets']}\n";
        }
        if (isset($decoded['error'])) {
            echo "Error: {$decoded['error']}\n";
        }
        if (isset($decoded['message'])) {
            echo "Mensaje: {$decoded['message']}\n";
        }
    }
}
?>